(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    437750,       8368]
NotebookOptionsPosition[    427405,       8178]
NotebookOutlinePosition[    427777,       8194]
CellTagsIndexPosition[    427734,       8191]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Cyclic Quadrilaterals", "Title",
 CellChangeTimes->{{3.8503675053983097`*^9, 3.8503675314147863`*^9}, {
   3.8504678198707952`*^9, 3.850467821360508*^9}, {3.8505617951146326`*^9, 
   3.8505618344846473`*^9}, 
   3.850567922474933*^9},ExpressionUUID->"1c7fd21f-91de-44e5-8756-\
935f2997f1d7"],

Cell["\<\

This Notebook contains the proofs of some of the results for cyclic \
quadrilaterals in the paper 
\"The Shape of Central Quadrilaterals\" by Stanley Rabinowitz and Ercole Suppa.
submitted to the International Journal of Computer Discovered Mathematics 
(http : // www.journal - 1. eu/) in January 2022.
 
This Notebook is Copyright \[Copyright] January 2022 by Ercole Suppa \
(ercolesuppa@gmail.co) and is published with open access. This Notebook is \
distributed under the terms of the Creative Commons Attribution License which \
permits any use, distribution, and reproduction in any medium, provided the \
original author and the source are credited.\
\>", "Text",
 Evaluatable->False,
 CellChangeTimes->{{3.823362867312365*^9, 3.823362892123764*^9}, {
  3.823362940554699*^9, 3.823363012293025*^9}, {3.823423241988761*^9, 
  3.8234232521964083`*^9}, {3.848655919648938*^9, 3.8486559295098267`*^9}, {
  3.850294942155574*^9, 3.8502949868845367`*^9}, {3.850318910197069*^9, 
  3.850318919556775*^9}, {3.850318983141321*^9, 3.850319001844956*^9}, {
  3.8504678253995905`*^9, 3.8504678619153557`*^9}, {3.8509122249008703`*^9, 
  3.8509122320912*^9}, {3.850915578124196*^9, 
  3.850915607526987*^9}},ExpressionUUID->"b2c8116c-ec79-4fb1-b532-\
250e1785d0c8"],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.8504689909025145`*^9, 3.8504690012525764`*^9}, {
  3.8504690713188334`*^9, 3.8504690736370955`*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"842befdc-3cf0-415f-8b25-\
c10324ffc1f1"],

Cell[CellGroupData[{

Cell[TextData[{
 "Functions extracted from package ",
 StyleBox["baricentricas",
  FontWeight->"Bold"],
 ", written by Francisco Javier Garcia Capitan "
}], "Subsection",
 CellChangeTimes->{
  3.818667972143658*^9, {3.818668111169589*^9, 3.8186681230042787`*^9}, {
   3.8186687874835854`*^9, 3.8186687997295856`*^9}, 
   3.81868471982917*^9},ExpressionUUID->"bbaef35b-fd46-44f6-8e80-\
c44bf68717ee"],

Cell[TextData[{
 "The full package ",
 StyleBox["baricentricas.m",
  FontWeight->"Bold",
  FontColor->GrayLevel[0]],
 " can be downloaded from:      ",
 ButtonBox["http : // garciacapitan.blogspot.com/2021/01/coordenadas - \
baricentricas.html",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://garciacapitan.blogspot.com/2021/01/coordenadas-baricentricas.\
html"], None},
  ButtonNote->
   "http://garciacapitan.blogspot.com/2021/01/coordenadas-baricentricas.html"]
}], "Text",
 CellChangeTimes->{{3.8186975420149603`*^9, 3.8186975893308125`*^9}, {
  3.818697637261342*^9, 3.81869763726334*^9}, {3.8504774633248463`*^9, 
  3.8504774678008566`*^9}},ExpressionUUID->"0059b8dc-ad99-42fc-a3b6-\
d879ef9097ac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Conway", " ", "notations"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SA", "=", 
     FractionBox[
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"], "-", 
       SuperscriptBox["a", "2"]}], "2"]}], ";", " ", 
    RowBox[{"SB", "=", 
     FractionBox[
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "2"]}], ";", 
    RowBox[{"SC", "=", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], "2"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Regla", " ", "para", " ", "sustituir", " ", "potencias", " ", "de", " ",
       "S"}], "=", 
     RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "funciones", " ", "para", " ", "reemplazar", " ", "valores", " ", "en", 
     " ", "una", " ", "expresi\[OAcute]n"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sustituir", "[", 
      RowBox[{"expr_", ",", "variable_", ",", "valor_"}], "]"}], ":=", 
     RowBox[{"Factor", "[", 
      RowBox[{"expr", " ", "/.", " ", 
       RowBox[{"Thread", "[", 
        RowBox[{"variable", "\[Rule]", "valor"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sustituirxyz", "[", 
      RowBox[{"f_", ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]_", ",", "\[Beta]_", ",", "\[Gamma]_"}], "}"}]}], 
      "]"}], ":=", 
     RowBox[{"Sustituir", "[", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}]}], 
      "]"}]}], " ", ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"TernaCiclica", "[", "expr", "]"}], " ", "returns", " ", 
       RowBox[{"{", 
        RowBox[{"expr1", ",", "expr2", ",", "expr3"}], "}"}], " ", "where", 
       " ", "expr1"}], "=", "expr"}], ",", " ", 
     RowBox[{"expr2", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"PermutarTerna", "[", "expr1", "]"}], " ", "and", " ", 
        "expr3"}], "=", 
       RowBox[{"PermutarTerna", "[", "expr2", "]"}]}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ReglaDePermutacion", "=", 
     RowBox[{"ReglaDePermutacion", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "b"}], ",", 
        RowBox[{"b", "\[Rule]", "c"}], ",", 
        RowBox[{"c", "\[Rule]", "a"}], ",", 
        RowBox[{"\[Alpha]", "\[Rule]", "\[Beta]"}], ",", 
        RowBox[{"\[Beta]", "\[Rule]", "\[Gamma]"}], ",", 
        RowBox[{"\[Gamma]", "\[Rule]", "\[Alpha]"}], ",", 
        RowBox[{"u", "\[Rule]", "v"}], ",", 
        RowBox[{"v", "\[Rule]", "w"}], ",", 
        RowBox[{"w", "\[Rule]", "u"}], ",", 
        RowBox[{"p", "\[Rule]", "q"}], ",", 
        RowBox[{"q", "\[Rule]", "r"}], ",", 
        RowBox[{"r", "\[Rule]", "p"}], ",", 
        RowBox[{"x", "\[Rule]", "y"}], ",", 
        RowBox[{"y", "\[Rule]", "z"}], ",", 
        RowBox[{"z", "\[Rule]", "x"}], ",", 
        RowBox[{"A", "\[Rule]", "B"}], ",", 
        RowBox[{"B", "\[Rule]", "C"}], ",", 
        RowBox[{"C", "\[Rule]", "A"}], ",", 
        RowBox[{"SA", "\[Rule]", "SB"}], ",", 
        RowBox[{"SB", "\[Rule]", "SC"}], ",", 
        RowBox[{"SC", "\[Rule]", "SA"}], ",", 
        RowBox[{"sa", "\[Rule]", "sb"}], ",", 
        RowBox[{"sb", "\[Rule]", "sc"}], ",", 
        RowBox[{"sc", "\[Rule]", "sa"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Permutar", "[", "expr_", "]"}], ":=", " ", 
     RowBox[{"expr", " ", "/.", "ReglaDePermutacion"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TernaCiclica", "[", "expr_", "]"}], " ", ":=", 
     RowBox[{"{", 
      RowBox[{"expr", ",", " ", 
       RowBox[{"Permutar", "[", "expr", "]"}], ",", 
       RowBox[{"Permutar", "[", 
        RowBox[{"Permutar", "[", "expr", "]"}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Simplificar", "[", "lista", "]"}], " ", "devuelve", " ", 
     "lista", " ", "dividida", " ", "por", " ", "su", " ", "M\[AAcute]ximo", 
     " ", "Com\[UAcute]n", " ", "Divisor"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Simplificar", "[", "list_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"gcd", ",", "lista"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"lista", "=", 
         RowBox[{"Factor", "[", "list", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"lista", "===", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", "lista", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"gcd", "=", 
            RowBox[{"Apply", "[", 
             RowBox[{"PolynomialGCD", ",", "lista"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"lista", "=", 
            RowBox[{"Simplify", "[", 
             RowBox[{"Divide", "[", 
              RowBox[{"lista", ",", "gcd"}], "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"UnsameQ", "[", 
              RowBox[{
               RowBox[{"Denominator", "[", "gcd", "]"}], ",", "1"}], "]"}], 
             ",", 
             RowBox[{"lista", "=", 
              RowBox[{"Simplificar", "[", 
               RowBox[{"lista", " ", 
                RowBox[{"Denominator", "[", "gcd", "]"}]}], "]"}]}]}], 
            "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", "lista"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    StyleBox[
     RowBox[{
     "ecuaci\[OAcute]n", " ", "de", " ", "una", " ", "recta", " ", "que", " ",
       "pasa", " ", "por", " ", "dos", " ", "puntos"}],
     FontWeight->"Bold"], 
    StyleBox[" ",
     FontWeight->"Bold"], 
    StyleBox["*)",
     FontWeight->"Bold"]}], 
   StyleBox[" ",
    FontWeight->"Bold"], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"P_", ",", "Q_"}], "]"}], " ", ":=", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"Cross", "[", 
       RowBox[{"P", ",", "Q"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"interseccion", " ", "de", " ", "dos", " ", "rectas"}], " ", 
    StyleBox["*)",
     FontWeight->"Bold"]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Punto", "[", 
      RowBox[{"r_", ",", "s_"}], "]"}], " ", ":=", " ", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"Cross", "[", 
       RowBox[{"r", ",", "s"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "punto", " ", "del", " ", "infinito", " ", "de", " ", "una", " ", "recta",
      " ", "perpendicular", " ", "a", " ", "una", " ", "recta", " ", "cuyo", 
     " ", "punto", " ", "del", " ", "infinito", " ", "es", " ", "ptJ"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PuntoInfinitoPerpendicular", "[", "ptJ_", "]"}], " ", ":=", 
     RowBox[{"PuntoInfinito", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"SA", ",", "SB", ",", "SC"}], "}"}], "ptJ"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "recta", " ", "perpendicular", " ", "a", " ", "otra", " ", "pasando", " ",
      "por", " ", "un", " ", "punto"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PuntoInfinito", "[", 
      RowBox[{"{", 
       RowBox[{"p_", ",", "q_", ",", "r_"}], "}"}], "]"}], " ", ":=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"q", "-", "r"}], ",", 
       RowBox[{"r", "-", "p"}], ",", 
       RowBox[{"p", "-", "q"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Perpendicular", "[", 
      RowBox[{"P_", ",", "r_"}], "]"}], " ", ":=", 
     RowBox[{"Recta", "[", 
      RowBox[{"P", ",", 
       RowBox[{"PuntoInfinitoPerpendicular", "[", 
        RowBox[{"PuntoInfinito", "[", "r", "]"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Perpendicular", "[", 
      RowBox[{"P_", ",", "Q_", ",", "R_"}], "]"}], ":=", 
     RowBox[{"Perpendicular", "[", 
      RowBox[{"P", ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "comprobaci\[OAcute]n", " ", "de", " ", "paralelismo", " ", "y", " ", 
     "perpendicularidad"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SonParalelas", "[", 
      RowBox[{"r_", ",", " ", "s_"}], "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{"Factor", "[", 
       RowBox[{
        RowBox[{"PuntoInfinito", "[", "r", "]"}], ".", "s"}], "]"}], " ", "==",
       " ", "0"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{"r_", ",", "s_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"PuntoInfinitoPerpendicular", "[", 
         RowBox[{"PuntoInfinito", "[", "r", "]"}], "]"}], ".", "s"}], "]"}], 
      "\[Equal]", "0"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "divisi\[OAcute]n", " ", "de", " ", "un", " ", "segmento", " ", "en", " ",
      "una", " ", "raz\[OAcute]n", " ", "dada"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DividirRazon", "[", 
      RowBox[{"ptP_", ",", "ptQ_", ",", " ", "m_", ",", " ", "n_"}], "]"}], 
     " ", ":=", 
     RowBox[{"Simplificar", "[", 
      RowBox[{
       RowBox[{"n", " ", 
        RowBox[{"Tr", "[", "ptQ", "]"}], " ", "ptP"}], " ", "+", " ", 
       RowBox[{"m", " ", 
        RowBox[{"Tr", "[", "ptP", "]"}], " ", "ptQ"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "punto", " ", "medio", " ", "del", " ", "segmento", " ", "de", " ", 
     "extremos", " ", "ptP", " ", "y", " ", "pt"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Medio", "[", 
      RowBox[{"ptP_", ",", "ptQ_"}], "]"}], " ", ":=", " ", 
     RowBox[{"DividirRazon", "[", 
      RowBox[{"ptP", ",", "ptQ", ",", " ", "1", ",", "1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calcula", " ", "la", " ", "mediatriz", " ", "del", " ", "segmento", " ", 
     "de", " ", "extremos", " ", "ptP", " ", "y", " ", "ptQ"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Mediatriz", "[", 
      RowBox[{"ptP_", ",", "ptQ_"}], "]"}], ":=", 
     RowBox[{"Perpendicular", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"ptP", ",", "ptQ"}], "]"}], ",", "ptP", ",", "ptQ"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calcula", " ", "la", " ", "mediana", " ", "del", " ", "segmento", " ", 
     "de", " ", "extremos", " ", "ptP", " ", "y", " ", "ptQ"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Mediana", "[", 
      RowBox[{"P_", ",", "Q_", ",", "R_"}], "]"}], " ", ":=", " ", 
     RowBox[{"Recta", "[", 
      RowBox[{"P", ",", " ", 
       RowBox[{"Medio", "[", 
        RowBox[{"Q", ",", " ", "R"}], " ", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculo", " ", "del", " ", "circuncentro", " ", "del", " ", 
     "tri\[AAcute]ngulo", " ", "ABC"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Circuncentro", "[", 
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_"}], "}"}], "]"}], " ", ":=", 
     RowBox[{"Punto", "[", 
      RowBox[{
       RowBox[{"Mediatriz", "[", 
        RowBox[{"ptA", ",", "ptB"}], "]"}], ",", 
       RowBox[{"Mediatriz", "[", 
        RowBox[{"ptA", ",", "ptC"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculo", " ", "del", " ", "baricentro", " ", "del", " ", 
     "tri\[AAcute]ngulo", " ", "ABC"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Baricentro", "[", 
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_"}], "}"}], "]"}], " ", ":=", 
     RowBox[{"Punto", "[", 
      RowBox[{
       RowBox[{"Mediana", "[", 
        RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "]"}], ",", 
       RowBox[{"Mediana", "[", 
        RowBox[{"ptB", ",", "ptC", ",", "ptA"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculo", " ", "del", " ", "ortocentro", " ", "del", " ", 
     "tri\[AAcute]ngulo", " ", "ABC"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_"}], "}"}], "]"}], " ", ":=", 
     " ", 
     RowBox[{"Punto", "[", 
      RowBox[{
       RowBox[{"Perpendicular", "[", 
        RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "]"}], ",", 
       RowBox[{"Perpendicular", "[", 
        RowBox[{"ptB", ",", "ptC", ",", "ptA"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculo", " ", "del", " ", "centro", " ", "de", " ", "nueve", " ", 
     "puntos", " ", "del", " ", "tri\[AAcute]ngulo", " ", "ABC"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CentroNuevePuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_"}], "}"}], "]"}], " ", ":=", 
     " ", 
     RowBox[{"Medio", "[", 
      RowBox[{
       RowBox[{"Ortocentro", "[", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}], "]"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculo", " ", "del", " ", "punto", " ", "de", " ", "DeLongchamps", " ", 
     "del", " ", "tri\[AAcute]ngulo", " ", "ABC"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DeLongchamps", "[", 
      RowBox[{"{", 
       RowBox[{"u_", ",", "v_", ",", "w_"}], "}"}], "]"}], ":=", 
     RowBox[{"SimetriaCentral", "[", 
      RowBox[{
       RowBox[{"Ortocentro", "[", 
        RowBox[{"{", 
         RowBox[{"u", ",", "v", ",", "w"}], "}"}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"u", ",", "v", ",", "w"}], "}"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculo", " ", "del", " ", "incentro", " ", "del", " ", 
     "tri\[AAcute]ngulo", " ", "ABC"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BisectrizInterior", "[", 
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_"}], "}"}], "]"}], ":=", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptA", ",", 
       RowBox[{"DividirRazon", "[", 
        RowBox[{"ptB", ",", "ptC", ",", 
         SqrtBox[
          RowBox[{"CuadradoDistancia", "[", 
           RowBox[{"ptA", ",", "ptB"}], "]"}]], ",", 
         SqrtBox[
          RowBox[{"CuadradoDistancia", "[", 
           RowBox[{"ptA", ",", "ptC"}], "]"}]]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Incentro", "[", 
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_"}], "}"}], "]"}], ":=", 
     RowBox[{"Punto", "[", 
      RowBox[{
       RowBox[{"BisectrizInterior", "[", 
        RowBox[{"{", 
         RowBox[{"ptB", ",", "ptA", ",", "ptC"}], "}"}], "]"}], ",", 
       RowBox[{"BisectrizInterior", "[", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}], "]"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "devuelve", " ", "las", " ", "coordenadas", " ", "baric\[EAcute]ntricas", 
     " ", "del", " ", "centro", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], " ", "del", " ", 
     "tri\[AAcute]ngulo", " ", "PQR"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CentroETCTriangulo", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptP_", ",", "ptQ_", ",", "ptR_"}], "}"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "siderules", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"siderules", "=", 
         RowBox[{"Thread", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], "\[Rule]", " ", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"MapThread", "[", 
             RowBox[{"CuadradoDistancia", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"ptQ", ",", "ptR", ",", "ptP"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"ptR", ",", "ptP", ",", "ptQ"}], "}"}]}], "}"}]}], 
             "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{"ptP", ",", "ptQ", ",", "ptR"}], "}"}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           FractionBox[
            RowBox[{"x", "/.", "siderules"}], 
            RowBox[{"Total", "[", "ptP", "]"}]], ",", 
           FractionBox[
            RowBox[{"y", "/.", "siderules"}], 
            RowBox[{"Total", "[", "ptQ", "]"}]], ",", 
           FractionBox[
            RowBox[{"z", "/.", "siderules"}], 
            RowBox[{"Total", "[", "ptR", "]"}]]}], "}"}]}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Determinar", " ", "si", " ", "los", " ", "puntos", " ", "de", " ", "una",
      " ", "lista", " ", "est\[AAcute]n", " ", "alineados"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EstanAlineados", "[", "lista_", "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{"MatrixRank", "[", "lista", "]"}], " ", "<", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Determinar", " ", "si", " ", "las", " ", "rectas", " ", "de", " ", "una",
      " ", "lista", " ", "son", " ", "concurrentes"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SonConcurrentes", "[", "lista_", "]"}], " ", ":=", " ", 
     RowBox[{"EstanAlineados", "[", "lista", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Determinar", " ", "si", " ", "los", " ", "puntos", " ", "de", " ", "una",
      " ", "lista", " ", "son", " ", "conciclicos"}], " ", "*)"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"SonConciclicos", "[", "lista_", "]"}], ":=", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lista1", "=", 
        RowBox[{"Union", "[", "lista", "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"EstanAlineados", "[", "lista1", "]"}]}], "&&", 
       RowBox[{"SonConcurrentes", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mediatriz", "[", 
            RowBox[{
             RowBox[{
             "lista1", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
              ",", "#1"}], "]"}], "&"}], ")"}], "/@", 
         RowBox[{"Drop", "[", 
          RowBox[{"lista1", ",", "1"}], "]"}]}], "]"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calcula", " ", "el", " ", "cuadrado", " ", "de", " ", "la", " ", 
     "distancia", " ", "de", " ", "dos", " ", "puntos"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u_", ",", "v_", ",", "w_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}]}], "]"}], " ", ":=", " ", 
     RowBox[{"Factor", "[", 
      RowBox[{"Divide", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"SA", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}], "x"}], "-", 
             RowBox[{"u", 
              RowBox[{"(", 
               RowBox[{"y", "+", "z"}], ")"}]}]}], ")"}], "2"]}], "+", 
         RowBox[{"SB", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"w", "+", "u"}], ")"}], "y"}], "-", 
             RowBox[{"v", 
              RowBox[{"(", 
               RowBox[{"z", "+", "x"}], ")"}]}]}], ")"}], "2"]}], "+", 
         RowBox[{"SC", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"u", "+", "v"}], ")"}], "z"}], "-", 
             RowBox[{"w", 
              RowBox[{"(", 
               RowBox[{"x", "+", "y"}], ")"}]}]}], ")"}], "2"]}]}], ",", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"u", "+", "v", "+", "w"}], ")"}], "2"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "+", "y", "+", "z"}], ")"}], "2"]}]}], "]"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Devuelve", " ", "la", " ", "ecuaci\[OAcute]n", " ", "de", " ", "la", " ",
      "circunferencia", " ", "que", " ", "pasa", " ", "por", " ", "tres", " ",
      "puntos"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x1_", ",", "y1_", ",", "z1_"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2_", ",", "y2_", ",", "z2_"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x3_", ",", "y3_", ",", "z3_"}], "}"}]}], "}"}], "]"}], ":=", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"a", "^", "2"}], " ", "y", " ", "z"}], "+", 
           RowBox[{
            RowBox[{"b", "^", "2"}], " ", "x", " ", "z"}], "+", 
           RowBox[{
            RowBox[{"c", "^", "2"}], " ", "x", " ", "y"}]}], ",", 
          RowBox[{"x", 
           RowBox[{"(", 
            RowBox[{"x", "+", "y", "+", "z"}], ")"}]}], ",", 
          RowBox[{"y", 
           RowBox[{"(", 
            RowBox[{"x", "+", "y", "+", "z"}], ")"}]}], ",", 
          RowBox[{"z", 
           RowBox[{"(", 
            RowBox[{"x", "+", "y", "+", "z"}], ")"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"a", "^", "2"}], " ", "y1", " ", "z1"}], "+", 
           RowBox[{
            RowBox[{"b", "^", "2"}], " ", "x1", " ", "z1"}], "+", 
           RowBox[{
            RowBox[{"c", "^", "2"}], " ", "x1", " ", "y1"}]}], ",", 
          RowBox[{"x1", 
           RowBox[{"(", 
            RowBox[{"x1", "+", "y1", "+", "z1"}], ")"}]}], ",", 
          RowBox[{"y1", 
           RowBox[{"(", 
            RowBox[{"x1", "+", "y1", "+", "z1"}], ")"}]}], ",", 
          RowBox[{"z1", 
           RowBox[{"(", 
            RowBox[{"x1", "+", "y1", "+", "z1"}], ")"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"a", "^", "2"}], " ", "y2", " ", "z2"}], "+", 
           RowBox[{
            RowBox[{"b", "^", "2"}], " ", "x2", " ", "z2"}], "+", 
           RowBox[{
            RowBox[{"c", "^", "2"}], " ", "x2", " ", "y2"}]}], ",", 
          RowBox[{"x2", 
           RowBox[{"(", 
            RowBox[{"x2", "+", "y2", "+", "z2"}], ")"}]}], ",", 
          RowBox[{"y2", 
           RowBox[{"(", 
            RowBox[{"x2", "+", "y2", "+", "z2"}], ")"}]}], ",", 
          RowBox[{"z2", 
           RowBox[{"(", 
            RowBox[{"x2", "+", "y2", "+", "z2"}], ")"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"a", "^", "2"}], " ", "y3", " ", "z3"}], "+", 
           RowBox[{
            RowBox[{"b", "^", "2"}], " ", "x3", " ", "z3"}], "+", 
           RowBox[{
            RowBox[{"c", "^", "2"}], " ", "x3", " ", "y3"}]}], ",", 
          RowBox[{"x3", 
           RowBox[{"(", 
            RowBox[{"x3", "+", "y3", "+", "z3"}], ")"}]}], ",", 
          RowBox[{"y3", 
           RowBox[{"(", 
            RowBox[{"x3", "+", "y3", "+", "z3"}], ")"}]}], ",", 
          RowBox[{"z3", 
           RowBox[{"(", 
            RowBox[{"x3", "+", "y3", "+", "z3"}], ")"}]}]}], "}"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "sim\[EAcute]trico", " ", "de", " ", "un", " ", "punto", " ", "respecto", 
     " ", "de", " ", "un", " ", "punto"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SimetriaCentral", "[", 
      RowBox[{"ptP_", ",", "ptO_"}], "]"}], " ", ":=", 
     RowBox[{"DividirRazon", "[", 
      RowBox[{"ptP", ",", " ", "ptO", ",", " ", "2", ",", 
       RowBox[{"-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"CuartaRecta", "[", 
      RowBox[{"ptP", ",", "r1", ",", "r2", ",", "r3"}], "]"}], " ", 
     "devuelve", " ", "la", " ", "recta", " ", "que", " ", "pasa", " ", "por",
      " ", "el", " ", "punto", " ", "ptP", " ", "y", " ", "que", " ", "forma",
      " ", "con", " ", "la", " ", "recta", " ", "r3", " ", "el", " ", "mismo",
      " ", "\[AAcute]ngulo", " ", "que", " ", "la", " ", "recta", " ", "r1", 
     " ", "forma", " ", "con", " ", "la", " ", "recta", " ", "r2"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CuartaRecta", "[", 
      RowBox[{"ptP_", ",", "r1_", ",", "r2_", ",", "r3_"}], "]"}], " ", ":=", 
     " ", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "S2", ",", "u1", ",", "v1", ",", "w1", ",", "u2", ",", "v2", ",", 
         "w2", ",", "u3", ",", "v3", ",", "w3", ",", "U1", ",", "V1", ",", 
         "W1", ",", "U3", ",", "V3", ",", "W3"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"S2", "=", 
         RowBox[{
          RowBox[{"SB", " ", "SC"}], " ", "+", " ", 
          RowBox[{"SC", " ", "SA"}], " ", "+", 
          RowBox[{"SA", " ", "SB"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u1", ",", "v1", ",", "w1"}], "}"}], "=", 
         RowBox[{"PuntoInfinito", "[", "r1", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u2", ",", "v2", ",", "w2"}], "}"}], "=", 
         RowBox[{"PuntoInfinito", "[", "r2", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u3", ",", "v3", ",", "w3"}], "}"}], "=", 
         RowBox[{"PuntoInfinito", "[", "r3", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"U1", ",", "V1", ",", "W1"}], "}"}], "=", 
         RowBox[{"PuntoInfinitoPerpendicular", "[", 
          RowBox[{"{", 
           RowBox[{"u1", ",", "v1", ",", "w1"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"U3", ",", "V3", ",", "W3"}], "}"}], "=", 
         RowBox[{"PuntoInfinitoPerpendicular", "[", 
          RowBox[{"{", 
           RowBox[{"u3", ",", "v3", ",", "w3"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Recta", "[", 
         RowBox[{"ptP", ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"S2", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"SA", " ", "u1", " ", "u2"}], " ", "+", " ", 
              RowBox[{"SB", " ", "v1", " ", "v2"}], " ", "+", " ", 
              RowBox[{"SC", " ", "w1", " ", "w2"}]}], ")"}], 
            RowBox[{"{", 
             RowBox[{"u3", ",", "v3", ",", "w3"}], "}"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"SA", " ", "U1", " ", "u2"}], " ", "+", 
              RowBox[{"SB", " ", "V1", " ", "v2"}], "+", " ", 
              RowBox[{"SC", " ", "W1", " ", "w2"}]}], ")"}], " ", 
            RowBox[{"{", 
             RowBox[{"U3", ",", "V3", ",", "W3"}], "}"}]}]}]}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Rotacion", "[", 
      RowBox[{"ptP", ",", " ", "ptQ", ",", "\[Alpha]"}], "]"}], " ", 
     "devuelve", " ", "el", " ", "resultado", " ", "de", " ", "aplicar", " ", 
     "a", " ", "P", " ", "una", " ", "rotaci\[OAcute]n", " ", "con", " ", 
     "centro", " ", "Q", " ", "y", " ", "\[AAcute]ngulo", " ", "\[Alpha]"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Rotacion", "[", 
      RowBox[{"ptP_", ",", "ptQ_", ",", "\[Alpha]_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Beta]", ",", "rtL1", ",", "rtL2", ",", "rtBC"}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"rtBC", "=", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[Beta]", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"\[Pi]", "-", "\[Alpha]"}], ")"}], "/", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rtL1", "=", 
         RowBox[{"Recta", "[", 
          RowBox[{"ptB", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], ",", 
             RowBox[{"SC", "+", 
              RowBox[{"S", " ", 
               RowBox[{"Cot", "[", "\[Alpha]", "]"}]}]}], ",", 
             RowBox[{"SB", "+", 
              RowBox[{"S", " ", 
               RowBox[{"Cot", "[", "\[Alpha]", "]"}]}]}]}], "}"}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"rtL2", "=", 
         RowBox[{"Recta", "[", 
          RowBox[{"ptB", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], ",", 
             RowBox[{"SC", "+", 
              RowBox[{"S", " ", 
               RowBox[{"Cot", "[", "\[Beta]", "]"}]}]}], ",", 
             RowBox[{"SB", "+", 
              RowBox[{"S", " ", 
               RowBox[{"Cot", "[", "\[Beta]", "]"}]}]}]}], "}"}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"Punto", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"CuartaRecta", "[", 
           RowBox[{"ptQ", ",", "rtL1", ",", "rtBC", ",", 
            RowBox[{"Recta", "[", 
             RowBox[{"ptQ", ",", "ptP"}], "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"CuartaRecta", "[", 
           RowBox[{"ptP", ",", "rtBC", ",", "rtL2", ",", 
            RowBox[{"Recta", "[", 
             RowBox[{"ptP", ",", "ptQ"}], "]"}]}], "]"}]}], 
         "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.800454214718548*^9, {3.8004545125571337`*^9, 3.8004545522620106`*^9}, {
   3.800454823663825*^9, 3.800454825213709*^9}, {3.8004548799575424`*^9, 
   3.80045493167925*^9}, {3.8004550228844185`*^9, 3.800455032322181*^9}, {
   3.800541517591076*^9, 3.8005415202139187`*^9}, {3.800541576118224*^9, 
   3.800541619198428*^9}, {3.8504693260035877`*^9, 3.8504693298535004`*^9}, {
   3.8504696257245083`*^9, 3.8504696447375326`*^9}, 3.8504723551991606`*^9, {
   3.8504727621325464`*^9, 3.8504727803188562`*^9}, {3.8504732048513374`*^9, 
   3.850473208157042*^9}, {3.850473648565755*^9, 3.8504736498256607`*^9}, {
   3.8504737473294554`*^9, 3.8504737479386873`*^9}, {3.8504737937107334`*^9, 
   3.8504738174177914`*^9}, {3.850474295952814*^9, 3.850474313805753*^9}, {
   3.850474380664278*^9, 3.8504744843179398`*^9}, {3.850474806608692*^9, 
   3.8504748552973075`*^9}, {3.8504759197123456`*^9, 3.850475921255512*^9}, {
   3.8504759713605905`*^9, 3.850475989464807*^9}, {3.850476575550455*^9, 
   3.850476577836243*^9}, {3.8504766181083813`*^9, 3.8504766473269916`*^9}, 
   3.850476830915382*^9, {3.85047733749861*^9, 3.850477347183383*^9}, {
   3.8504775310644264`*^9, 3.8504775480417814`*^9}, {3.8504776562952366`*^9, 
   3.850477657888199*^9}, {3.850477691257831*^9, 3.8504777395182476`*^9}, {
   3.8504777946094065`*^9, 3.8504778318856945`*^9}, {3.8504778879052052`*^9, 
   3.850477979968292*^9}, 3.85047801764312*^9, {3.85047805752918*^9, 
   3.8504781433438506`*^9}, {3.8504783920073695`*^9, 3.8504783936911545`*^9}, 
   3.850478526788954*^9, {3.850478609511713*^9, 3.850478653416582*^9}, {
   3.8504786913025217`*^9, 3.850478693318307*^9}, {3.850478740794073*^9, 
   3.8504787409729986`*^9}, {3.850478771789158*^9, 3.8504787935997972`*^9}, {
   3.850484068631645*^9, 3.8504840770175076`*^9}, {3.850484550888462*^9, 
   3.8504846052672358`*^9}, {3.8504847102887387`*^9, 3.850484735950554*^9}, {
   3.8504847855035887`*^9, 3.8504847864403706`*^9}, {3.8504871476004524`*^9, 
   3.850487149953966*^9}, {3.8504872253185596`*^9, 3.8504872259167852`*^9}, {
   3.8504878691388655`*^9, 3.850487872991275*^9}, {3.8505176008539124`*^9, 
   3.8505176371017017`*^9}, {3.8505481409495125`*^9, 
   3.8505481804024105`*^9}, {3.850548222854543*^9, 3.8505482529883375`*^9}, {
   3.8505488322145867`*^9, 3.850548833050748*^9}, {3.8505488800200253`*^9, 
   3.8505488925908394`*^9}, {3.850548927000965*^9, 3.8505489320600038`*^9}, {
   3.850550143778785*^9, 3.850550165531348*^9}, 3.8505539915737514`*^9, {
   3.850561615613713*^9, 3.8505616204784827`*^9}, {3.8505678506297703`*^9, 
   3.8505678517386513`*^9}, {3.8509153872758327`*^9, 3.8509154066306*^9}, {
   3.8509154401987057`*^9, 3.8509154685206223`*^9}, {3.8509187532712116`*^9, 
   3.850918753847083*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"57ddaf88-15ec-4784-8204-24a0ef11a487"]
}, Closed]],

Cell[CellGroupData[{

Cell["Auxiliary functions", "Subsection",
 CellChangeTimes->{
  3.818667972143658*^9, {3.8186680382464933`*^9, 3.818668041714528*^9}, {
   3.818668136826049*^9, 3.818668143553762*^9}, {3.8186851837176514`*^9, 
   3.8186851857111263`*^9}},ExpressionUUID->"06785e74-858a-4fba-88ad-\
d2a22a9f4998"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"convertToABCrule", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "A", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}], "-", 
          RowBox[{"a", "^", "2"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "b", "*", "c"}], ")"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Cos", "[", "B", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", "^", "2"}], "+", 
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c", "*", "a"}], ")"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Cos", "[", "C", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "+", 
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "a", "*", "b"}], ")"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Sec", "[", "A", "]"}], "\[Rule]", 
       RowBox[{"2", "*", "b", "*", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ")"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Sec", "[", "B", "]"}], "\[Rule]", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"a", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "^", "2"}], "+", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Sec", "[", "C", "]"}], "\[Rule]", 
       RowBox[{"2", "*", "a", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Sin", "[", "A", "]"}], "\[Rule]", " ", 
       RowBox[{"a", "/", 
        RowBox[{"(", 
         RowBox[{"2", "R"}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "B", "]"}], "\[Rule]", " ", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"2", "R"}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "C", "]"}], "\[Rule]", " ", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{"2", "R"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"R", "\[Rule]", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"4", "K"}], ")"}]}]}]}], ",", " ", 
      RowBox[{"r", "\[Rule]", 
       RowBox[{"K", "/", "s"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tan", "[", "A", "]"}], "\[Rule]", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"R", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "^", "2"}], "+", 
             RowBox[{"c", "^", "2"}], "-", 
             RowBox[{"a", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tan", "[", "B", "]"}], "\[Rule]", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"R", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"c", "^", "2"}], "+", 
             RowBox[{"a", "^", "2"}], "-", 
             RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tan", "[", "C", "]"}], "\[Rule]", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"R", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "+", 
             RowBox[{"b", "^", "2"}], "-", 
             RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"K", "\[Rule]", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"s", 
         RowBox[{"(", 
          RowBox[{"s", "-", "a"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"s", "-", "b"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"s", "-", "c"}], ")"}]}], "]"}]}], ",", " ", 
      RowBox[{"s", "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "+", "c"}], ")"}], "/", "2"}]}]}], "}"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"convertToABC", "[", "expr_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"expr1", ",", "expr2"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"expr1", "=", "expr"}], ";", "\[IndentingNewLine]", 
       RowBox[{"expr2", "=", 
        RowBox[{"TrigExpand", "[", "expr1", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"expr2", "=", 
        RowBox[{"expr2", "//.", "convertToABCrule"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"expr2", "=", 
        RowBox[{"Simplify", "[", "expr2", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "expr2", "]"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Fermat1", "[", 
     RowBox[{"{", 
      RowBox[{"P1_", ",", "P2_", ",", "P3_"}], "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P4", ",", "P5", ",", "res"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"P4", "=", 
        RowBox[{"Rotacion", "[", 
         RowBox[{"P3", ",", "P1", ",", 
          RowBox[{"\[Pi]", "/", "3"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"P5", "=", 
        RowBox[{"Rotacion", "[", 
         RowBox[{"P1", ",", "P2", ",", 
          RowBox[{"\[Pi]", "/", "3"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"res", "=", 
        RowBox[{"Punto", "[", 
         RowBox[{
          RowBox[{"Recta", "[", 
           RowBox[{"P2", ",", "P4"}], "]"}], ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"P3", ",", "P5"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", "=", 
        RowBox[{"Simplificar", "[", 
         RowBox[{
          RowBox[{"Expand", "[", "res", "]"}], "//.", "sustS"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "res", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Fermat2", "[", 
     RowBox[{"{", 
      RowBox[{"P1_", ",", "P2_", ",", "P3_"}], "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P4", ",", "P5", ",", "res"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"P4", "=", 
        RowBox[{"Rotacion", "[", 
         RowBox[{"P1", ",", "P3", ",", 
          RowBox[{"\[Pi]", "/", "3"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"P5", "=", 
        RowBox[{"Rotacion", "[", 
         RowBox[{"P2", ",", "P1", ",", 
          RowBox[{"\[Pi]", "/", "3"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"res", "=", 
        RowBox[{"Punto", "[", 
         RowBox[{
          RowBox[{"Recta", "[", 
           RowBox[{"P2", ",", "P4"}], "]"}], ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"P3", ",", "P5"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", "=", 
        RowBox[{"Simplificar", "[", 
         RowBox[{
          RowBox[{"Expand", "[", "res", "]"}], "//.", "sustS"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "res", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Vecten1", "[", 
     RowBox[{"{", 
      RowBox[{"P1_", ",", "P2_", ",", "P3_"}], "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "P4", ",", "P5", ",", "P6", ",", "P7", ",", "P8", ",", "P9", ",", 
        "res"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"P4", "=", 
        RowBox[{"Rotacion", "[", 
         RowBox[{"P1", ",", "P3", ",", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"P5", "=", 
        RowBox[{"Rotacion", "[", 
         RowBox[{"P3", ",", "P1", ",", 
          RowBox[{"\[Pi]", "/", "2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"P6", "=", 
        RowBox[{"Rotacion", "[", 
         RowBox[{"P2", ",", "P1", ",", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"P7", "=", 
        RowBox[{"Rotacion", "[", 
         RowBox[{"P1", ",", "P2", ",", 
          RowBox[{"\[Pi]", "/", "2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"P8", "=", 
        RowBox[{"Punto", "[", 
         RowBox[{
          RowBox[{"Recta", "[", 
           RowBox[{"P1", ",", "P4"}], "]"}], ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"P3", ",", "P5"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"P9", "=", 
        RowBox[{"Punto", "[", 
         RowBox[{
          RowBox[{"Recta", "[", 
           RowBox[{"P1", ",", "P7"}], "]"}], ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"P2", ",", "P6"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", "=", 
        RowBox[{"Punto", "[", 
         RowBox[{
          RowBox[{"Recta", "[", 
           RowBox[{"P2", ",", "P8"}], "]"}], ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"P3", ",", "P9"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", "=", 
        RowBox[{"Simplificar", "[", 
         RowBox[{
          RowBox[{"Expand", "[", "res", "]"}], "//.", "sustS"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "res", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Vecten2", "[", 
     RowBox[{"{", 
      RowBox[{"P1_", ",", "P2_", ",", "P3_"}], "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "P4", ",", "P5", ",", "P6", ",", "P7", ",", "P8", ",", "P9", ",", 
        "res"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"P4", "=", 
        RowBox[{"Rotacion", "[", 
         RowBox[{"P3", ",", "P1", ",", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"P5", "=", 
        RowBox[{"Rotacion", "[", 
         RowBox[{"P1", ",", "P3", ",", 
          RowBox[{"\[Pi]", "/", "2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"P6", "=", 
        RowBox[{"Rotacion", "[", 
         RowBox[{"P2", ",", "P1", ",", 
          RowBox[{"\[Pi]", "/", "2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"P7", "=", 
        RowBox[{"Rotacion", "[", 
         RowBox[{"P1", ",", "P2", ",", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"P8", "=", 
        RowBox[{"Punto", "[", 
         RowBox[{
          RowBox[{"Recta", "[", 
           RowBox[{"P1", ",", "P5"}], "]"}], ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"P3", ",", "P4"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"P9", "=", 
        RowBox[{"Punto", "[", 
         RowBox[{
          RowBox[{"Recta", "[", 
           RowBox[{"P1", ",", "P7"}], "]"}], ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"P2", ",", "P6"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", "=", 
        RowBox[{"Punto", "[", 
         RowBox[{
          RowBox[{"Recta", "[", 
           RowBox[{"P2", ",", "P8"}], "]"}], ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"P3", ",", "P9"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res", "=", 
        RowBox[{"Simplificar", "[", 
         RowBox[{
          RowBox[{"Expand", "[", "res", "]"}], "//.", "sustS"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "res", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RectangleQ", "[", 
     RowBox[{"{", 
      RowBox[{"P1_", ",", "P2_", ",", "P3_", ",", "P4_"}], "}"}], "]"}], ":=", 
    RowBox[{"And", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SonParalelas", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P1", ",", "P2"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"P3", ",", "P4"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SonParalelas", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P1", ",", "P4"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"P2", ",", "P3"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SonPerpendiculares", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P1", ",", "P2"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"P2", ",", "P3"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"IsoscelesTrapezoidQ", "[", 
     RowBox[{"{", 
      RowBox[{"P1_", ",", "P2_", ",", "P3_", ",", "P4_"}], "}"}], "]"}], ":=", 
    RowBox[{"Or", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"And", "[", 
       RowBox[{
        RowBox[{"SonParalelas", "[", 
         RowBox[{
          RowBox[{"Recta", "[", 
           RowBox[{"P1", ",", "P4"}], "]"}], ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"P2", ",", "P3"}], "]"}]}], "]"}], ",", 
        RowBox[{"SameQ", "[", 
         RowBox[{
          RowBox[{"Factor", "[", 
           RowBox[{
            RowBox[{"CuadradoDistancia", "[", 
             RowBox[{"P1", ",", "P2"}], "]"}], "-", 
            RowBox[{"CuadradoDistancia", "[", 
             RowBox[{"P3", ",", "P4"}], "]"}]}], "]"}], ",", "0"}], "]"}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"And", "[", 
       RowBox[{
        RowBox[{"SonParalelas", "[", 
         RowBox[{
          RowBox[{"Recta", "[", 
           RowBox[{"P1", ",", "P2"}], "]"}], ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"P3", ",", "P4"}], "]"}]}], "]"}], ",", 
        RowBox[{"SameQ", "[", 
         RowBox[{
          RowBox[{"Factor", "[", 
           RowBox[{
            RowBox[{"CuadradoDistancia", "[", 
             RowBox[{"P1", ",", "P4"}], "]"}], "-", 
            RowBox[{"CuadradoDistancia", "[", 
             RowBox[{"P2", ",", "P3"}], "]"}]}], "]"}], ",", "0"}], "]"}]}], 
       "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OrhodiagonalQuadQ", "[", 
    RowBox[{"{", 
     RowBox[{"P1_", ",", "P2_", ",", "P3_", ",", "P4_"}], "}"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "res", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"res", "=", 
       RowBox[{"First", "[", 
        RowBox[{"SonPerpendiculares", "[", 
         RowBox[{
          RowBox[{"Recta", "[", 
           RowBox[{"P1", ",", "P3"}], "]"}], ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"P2", ",", "P4"}], "]"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"res", "=", 
       RowBox[{"Factor", "[", 
        RowBox[{
         RowBox[{"Expand", "[", "res", "]"}], "//.", "sustS"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"res", "===", "0"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.8504891290157404`*^9, 3.8504891376685266`*^9}, {
  3.850563747113697*^9, 3.850563748088766*^9}, {3.850566683939293*^9, 
  3.850566685204341*^9}, {3.8505676309711847`*^9, 3.8505676486784296`*^9}, {
  3.850567698123333*^9, 3.850567716752717*^9}, {3.8505677581780963`*^9, 
  3.8505677779739676`*^9}, {3.850912848156225*^9, 3.850912849083126*^9}, {
  3.8509154996445403`*^9, 3.8509155017846303`*^9}},
 CellLabel->
  "In[116]:=",ExpressionUUID->"f5e25769-1ea5-4c75-9916-55398bf3e085"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.8504689909025145`*^9, 3.8504690012525764`*^9}, {
   3.8504690713188334`*^9, 3.8504690736370955`*^9}, 
   3.850469177050805*^9},ExpressionUUID->"3e0086bf-9422-4176-8e91-\
c63f1a449dad"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"$Assumptions", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", ">", "0"}], ",", 
      RowBox[{"b", ">", "0"}], ",", 
      RowBox[{"c", ">", "0"}], ",", 
      RowBox[{
       RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
      RowBox[{
       RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
      RowBox[{
       RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}], ",", 
      RowBox[{"t", ">", "0"}], ",", 
      RowBox[{"t", "<", "1"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptA", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptB", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptC", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptD", "=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptE", "=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptA", ",", "ptC"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptB", ",", "ptD"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.815380012932528*^9, 3.815380017875984*^9}, 
   3.8504690403531494`*^9, {3.8504693680519905`*^9, 3.850469423540739*^9}, {
   3.8504729278850822`*^9, 3.8504729485372677`*^9}, {3.850473440747275*^9, 
   3.8504734481722603`*^9}, {3.850475925894286*^9, 3.850475928077327*^9}, {
   3.8504761619065633`*^9, 3.8504761743904066`*^9}, {3.8505562063338566`*^9, 
   3.850556223600524*^9}, {3.8505562541705465`*^9, 3.850556312095413*^9}, {
   3.8505595402294674`*^9, 3.850559540656997*^9}, {3.850559577535342*^9, 
   3.8505595778428125`*^9}},
 CellLabel->
  "In[125]:=",ExpressionUUID->"ed2efd3a-5513-4d7f-91d5-aa4c40ba43b6"],

Cell[TextData[StyleBox["Point T on AC such that AT : TC = t : 1, with 0 \
\[LessEqual] t \[LessEqual] 1.",
 FontColor->GrayLevel[0]]], "Text",
 CellChangeTimes->{{3.8172936317334456`*^9, 3.817293669912202*^9}, {
  3.8172945191307793`*^9, 
  3.8172945677066755`*^9}},ExpressionUUID->"7218253a-f9e3-4e79-bc14-\
b67cfbaa90a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptT", "=", 
  RowBox[{"DividirRazon", "[", 
   RowBox[{"ptA", ",", "ptC", ",", "t", ",", "1"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8153943277906637`*^9, 3.8153943533872595`*^9}, {
   3.8172935886233587`*^9, 3.817293590671271*^9}, 3.8505560088454385`*^9, 
   3.850556165035162*^9},
 CellLabel->
  "In[131]:=",ExpressionUUID->"fb0b2316-1cc0-4ff9-9612-a28276348a1b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "t"}], "}"}]], "Output",
 CellChangeTimes->{3.8153943552616367`*^9, 3.8153944364131002`*^9, 
  3.81727674378023*^9, 3.8172935920367208`*^9, 3.8504693856702104`*^9, 
  3.85046942698629*^9, 3.8504727237543945`*^9, 3.8505177479014235`*^9, 
  3.850554109409218*^9, 3.8505560460500946`*^9, 3.850556124094026*^9, 
  3.8505561713685017`*^9, 3.850556593131568*^9, 3.850564126489251*^9, 
  3.850564248903241*^9, 3.8505675459196777`*^9, 3.8505730856858573`*^9, 
  3.8505737165676312`*^9, 3.850913176467263*^9, 3.85091858704643*^9, 
  3.851255515638445*^9},
 CellLabel->
  "Out[131]=",ExpressionUUID->"7d622c77-ee5c-4361-9e77-77b9be7bfdc6"]
}, Open  ]],

Cell[TextData[StyleBox["Equation of the line BT",
 FontColor->GrayLevel[0]]], "Text",
 CellChangeTimes->{{3.8504734939279647`*^9, 
  3.850473502240715*^9}},ExpressionUUID->"eafe411f-dfde-47ec-bad4-\
3820d3bd5ab5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rtBT", "=", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptB", ",", "ptT"}], "]"}], ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.8504734633049297`*^9, 3.850473479163158*^9}, 
   3.850556039175776*^9, 3.85055617778605*^9},
 CellLabel->
  "In[132]:=",ExpressionUUID->"f9553f73-9b84-4571-ac63-7c64c684c724"],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", " ", "x"}], "-", "z"}]], "Output",
 CellChangeTimes->{
  3.8504734807467723`*^9, 3.8505177479483027`*^9, 3.850554109440428*^9, 
   3.850556048040804*^9, 3.850556095323677*^9, 3.850556127178358*^9, {
   3.8505561735461206`*^9, 3.8505561782858343`*^9}, 3.8505565931627827`*^9, 
   3.850564126520494*^9, 3.8505642489188623`*^9, 3.8505675459509206`*^9, 
   3.8505730857170997`*^9, 3.8505737166026626`*^9, 3.8509131765031676`*^9, 
   3.8509185870760007`*^9, 3.8512555156617737`*^9},
 CellLabel->
  "Out[132]=",ExpressionUUID->"61f5051f-4b8b-4dba-9ced-fbb4f44e81ba"]
}, Open  ]],

Cell[TextData[StyleBox["Generic point D on the arc AC that not contains B",
 FontColor->GrayLevel[0]]], "Text",
 CellChangeTimes->{{3.8172937029864607`*^9, 
  3.8172937342236505`*^9}},ExpressionUUID->"aa8d4996-63ea-4ed9-a0d4-\
085fc14e0816"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"circumcircle", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "y", " ", "z"}], " ", "+", " ", 
    RowBox[{
     SuperscriptBox["b", 
      RowBox[{"2", " "}]], "z", " ", "x"}], " ", "+", " ", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", "x", " ", "y"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ptDt", "=", 
  RowBox[{"Quiet", "[", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/.", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"circumcircle", "\[Equal]", "0"}], ",", 
          RowBox[{"rtBT", "\[Equal]", "0"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8153943596711855`*^9, 3.8153944127641115`*^9}, {
   3.8172935964607906`*^9, 3.8172935970077744`*^9}, 3.850473134703077*^9, {
   3.8504734729173584`*^9, 3.8504734762480726`*^9}, 3.8505560992985945`*^9, {
   3.850559585233466*^9, 3.8505595863634653`*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"5af2e9d2-8eaa-44f7-9dd4-ec3f8068c3e3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "t"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["b", "2"]}], " ", "t"}], ",", 
   RowBox[{"t", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "t"}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8153944138341007`*^9, 3.8153944376693354`*^9}, 
   3.8172767440489454`*^9, 3.8172935977522793`*^9, 3.850473135625296*^9, 
   3.850473529484647*^9, 3.8505177479951677`*^9, 3.8505541094872913`*^9, {
   3.8505561073270755`*^9, 3.8505561322976675`*^9}, 3.85055618379031*^9, 
   3.850556593194026*^9, 3.85055959498328*^9, 3.850564126573888*^9, 
   3.850564248950116*^9, 3.8505675459821625`*^9, 3.8505730857483435`*^9, 
   3.8505737166406956`*^9, 3.8509131765422726`*^9, 3.850918587116891*^9, 
   3.851255515696641*^9},
 CellLabel->
  "Out[134]=",ExpressionUUID->"cbd8980d-b8c2-4ed6-ad56-ea3b67efa2e1"]
}, Open  ]],

Cell[TextData[StyleBox["The quadrilateral ABCD is cyclic if {u,v,w} = \
{-c^2-a^2 t,b^2 t,-t (c^2+a^2 t)}, for some t, 0 \[LessEqual] t \[LessEqual] \
1.",
 FontColor->GrayLevel[0]]], "Text",
 CellChangeTimes->{{3.8172937442830706`*^9, 3.8172937686257634`*^9}, {
  3.8172938037786694`*^9, 3.8172938337177153`*^9}, {3.8172946103361287`*^9, 
  3.8172946110423174`*^9}, {3.850473254759699*^9, 3.850473260070614*^9}, {
  3.850556343706728*^9, 3.850556388919695*^9}, {3.8505565548918114`*^9, 
  3.850556556360215*^9}},ExpressionUUID->"78961a6c-61a2-424e-9f9b-\
9c12e1cd90c9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sustD", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w"}], "}"}], "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "t"}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], " ", "t"}], ",", 
       RowBox[{"t", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "t"}]}], ")"}]}]}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8505564295564365`*^9, 3.85055648417801*^9}, {
   3.8505565199576087`*^9, 3.850556520894913*^9}, 3.8505594668225803`*^9},
 CellLabel->
  "In[135]:=",ExpressionUUID->"9812470e-839c-411e-bbe5-1d4a082d2039"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quarter Triangles", "Section",
 CellChangeTimes->{{3.850563509178241*^9, 3.850563518695816*^9}, {
  3.850563680472247*^9, 
  3.8505636824612675`*^9}},ExpressionUUID->"1652b3e5-8836-4d3a-ba58-\
f1053f99bfcd"],

Cell[TextData[StyleBox["Quarter triangles of a general quadrilateral",
 FontColor->GrayLevel[0]]], "Text",
 CellChangeTimes->{{3.8505565059770575`*^9, 3.850556533657157*^9}, 
   3.8505593391329474`*^9, {3.8505594920934362`*^9, 3.8505595161787663`*^9}, {
   3.85056391562743*^9, 
   3.8505639171897583`*^9}},ExpressionUUID->"df684cc8-f09e-40ad-af97-\
6ee54bcf5e39"],

Cell[BoxData[
 RowBox[{
  RowBox[{"quarterTrianglesOfGeneralQuad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.850559348281557*^9, 3.850559478838481*^9}, {
  3.850559519513784*^9, 3.850559521517284*^9}, {3.8505638507031865`*^9, 
  3.8505638943529572`*^9}, {3.850563932261676*^9, 3.850563936344741*^9}, {
  3.850563970438076*^9, 3.850564005379706*^9}},
 CellLabel->
  "In[136]:=",ExpressionUUID->"a87552a0-095f-49ea-ae9a-b85706010ccb"],

Cell[TextData[StyleBox["Quarter triangles of a cyclic quadrilateral",
 FontColor->GrayLevel[0]]], "Text",
 CellChangeTimes->{{3.8505565059770575`*^9, 3.850556533657157*^9}, 
   3.8505593391329474`*^9, {3.8505594920934362`*^9, 3.8505595104436374`*^9}, {
   3.850563921865839*^9, 
   3.8505639238421583`*^9}},ExpressionUUID->"eef60890-d21c-40a9-a231-\
4f2e16a6ff64"],

Cell[BoxData[
 RowBox[{
  RowBox[{"quarterTrianglesOfCyclicQuad", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}], "/.", 
    "sustD"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8505638875338173`*^9, 3.850563889642337*^9}, {
   3.8505639419910355`*^9, 3.8505639433719554`*^9}, 3.850564024761902*^9},
 CellLabel->
  "In[137]:=",ExpressionUUID->"7c7c5886-d881-4b48-8c2d-96409472e4a1"],

Cell[CellGroupData[{

Cell["Theorem 5.11", "Subsection",
 CellChangeTimes->{{3.850367662817922*^9, 3.850367681472711*^9}, {
  3.850468046384611*^9, 3.850468047773791*^9}, {3.850468091473277*^9, 
  3.8504680956818314`*^9}, {3.850474108128826*^9, 3.8504741118490105`*^9}, {
  3.8504906158887424`*^9, 3.8504906179923196`*^9}, {3.8512558276848583`*^9, 
  3.851255828068389*^9}},ExpressionUUID->"aa1e1384-cc65-4bf2-89db-\
e20816cdccd4"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3Qu8FeP+x/FRndzl4CCkkCgpijqokN3dVuxd0Q1dkJwKf3IkRFRCbuVQ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    "], {{0, 768}, {1340, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{1340, 768},
  PlotRange->{{0, 1340}, {0, 768}}]], "Text",
 CellChangeTimes->{
  3.8504762697218065`*^9, 3.8504906129644904`*^9, {3.851255883303039*^9, 
   3.8512558974810333`*^9}},ExpressionUUID->"db3a72e1-fa24-4759-ae2e-\
bf7bc9780a4c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"X110", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}]}], ",", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], "+", 
          SuperscriptBox["b", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}]}], ",", 
       RowBox[{
        SuperscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"Factor", "[", 
          RowBox[{"Simplify", "[", 
           RowBox[{"CentroETCTriangulo", "[", 
            RowBox[{"X110", ",", "#"}], "]"}], "]"}], "]"}], "]"}], "&"}], 
       ",", "quarterTrianglesOfCyclicQuad"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"IsoscelesTrapezoidQ", "[", 
    RowBox[{"{", 
     RowBox[{"ptF", ",", "ptH", ",", "ptG", ",", "ptI"}], "}"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.850491970562947*^9, 3.8504919897383146`*^9}, {
  3.850492069397854*^9, 3.8504921444844904`*^9}, {3.8504934034681196`*^9, 
  3.8504934133169374`*^9}, {3.8505640389943027`*^9, 3.850564093662662*^9}},
 CellLabel->
  "In[138]:=",ExpressionUUID->"5cea681d-8bb1-49dd-a61e-f40950bcb0ac"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.8504934080119205`*^9, 3.8504934182593765`*^9}, 
   3.8505642668192153`*^9, 3.850567567881508*^9, 3.8505680652297096`*^9, 
   3.850918603038457*^9, 3.8512555204465017`*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"c9c38e6b-823e-422e-801c-108d31d7b397"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 5.12", "Subsection",
 CellChangeTimes->{{3.850367662817922*^9, 3.850367681472711*^9}, {
   3.850468046384611*^9, 3.850468047773791*^9}, {3.850468091473277*^9, 
   3.8504680956818314`*^9}, {3.850474108128826*^9, 3.8504741118490105`*^9}, 
   3.850476924842958*^9, {3.8504906396190414`*^9, 3.8504906408744974`*^9}, 
   3.8512559396933413`*^9},ExpressionUUID->"6cff85a6-6ec8-4ed4-a9d8-\
7a640c6dd7a7"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsnQd4FdW2xwdQRBTxAiooHQTB0JtCQITQCS0JLYSOgChFFFSKoEgRlSLl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    "], {{0, 122}, {1328, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{1328, 122},
  PlotRange->{{0, 1328}, {0, 122}}]], "Text",
 CellChangeTimes->{
  3.8504762761093454`*^9, 3.8504906462002163`*^9, 3.850912992141704*^9, 
   3.8509143968291206`*^9, {3.85125598749631*^9, 
   3.851255994726529*^9}},ExpressionUUID->"b71dfe76-4e1f-4207-83cc-\
fde6f563eec3"],

Cell[CellGroupData[{

Cell["1st Vecten point X(485)", "Subsubsection",
 CellChangeTimes->{{3.8504825710248966`*^9, 3.850482593743327*^9}, {
  3.8504826244903092`*^9, 3.8504826357438765`*^9}, {3.850482746920953*^9, 
  3.850482778463234*^9}, {3.8504906624019284`*^9, 3.8504906917458944`*^9}, {
  3.8505644155778713`*^9, 
  3.8505644236383114`*^9}},ExpressionUUID->"f35cafcc-c84d-41ff-89ce-\
0dac02cf6b19"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Vecten1", ",", "quarterTrianglesOfCyclicQuad"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"OrhodiagonalQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8505649753766212`*^9, 3.8505649877184153`*^9}, {
  3.850565041394397*^9, 3.8505650788359423`*^9}, {3.8505661501745515`*^9, 
  3.8505661921439753`*^9}, {3.8505663076051774`*^9, 3.850566310483141*^9}, {
  3.8505667095710955`*^9, 3.850566729457627*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"042186c9-72fd-491b-8f3c-1f3b5b49fef6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.8505667307590475`*^9, {3.8505675823507547`*^9, 3.8505676082224407`*^9}, 
   3.850913197052418*^9, 3.850914047193286*^9, 3.8509145514361005`*^9, 
   3.850918619167533*^9, 3.851255526120749*^9},
 CellLabel->
  "Out[142]=",ExpressionUUID->"6b8d8e98-4425-444a-a17a-02ceb0aa48d3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2nd Vecten point X(486)", "Subsubsection",
 CellChangeTimes->{{3.8504825710248966`*^9, 3.850482593743327*^9}, {
   3.8504826244903092`*^9, 3.8504826357438765`*^9}, {3.850482746920953*^9, 
   3.850482778463234*^9}, {3.8504906624019284`*^9, 3.8504906917458944`*^9}, {
   3.8505644155778713`*^9, 3.8505644236383114`*^9}, {3.850566748837355*^9, 
   3.8505667523223906`*^9}, 
   3.851256012994193*^9},ExpressionUUID->"f371521d-eb6a-48e9-a2f7-\
52534997fde1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Vecten2", ",", "quarterTrianglesOfCyclicQuad"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"OrhodiagonalQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8505649753766212`*^9, 3.8505649877184153`*^9}, {
  3.850565041394397*^9, 3.8505650788359423`*^9}, {3.8505661501745515`*^9, 
  3.8505661921439753`*^9}, {3.8505663076051774`*^9, 3.850566310483141*^9}, {
  3.8505667095710955`*^9, 3.850566729457627*^9}, {3.850567031958255*^9, 
  3.8505670320178876`*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"935b73b0-0939-4a4e-bce2-15985588d8bd"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.8505667307590475`*^9, 3.850567044798173*^9, 
  3.8505676019201665`*^9, 3.850913209348217*^9, 3.8509136069190483`*^9, 
  3.850918626906142*^9, 3.8512555317763023`*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"5e0beb26-3e21-402e-bd95-16dd5bb61809"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Half Triangles", "Section",
 CellChangeTimes->{{3.850563509178241*^9, 
  3.850563518695816*^9}},ExpressionUUID->"633221b1-6e5a-4260-9424-\
adc26de09800"],

Cell[TextData[StyleBox["Half triangles of a general quadrilateral",
 FontColor->GrayLevel[0]]], "Text",
 CellChangeTimes->{{3.8505565059770575`*^9, 3.850556533657157*^9}, 
   3.8505593391329474`*^9, {3.8505594920934362`*^9, 
   3.8505595161787663`*^9}},ExpressionUUID->"94b81001-fb04-4746-b0c7-\
2314a1ff7944"],

Cell[BoxData[
 RowBox[{
  RowBox[{"halfTrianglesOfGeneralQuad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.850559348281557*^9, 3.850559478838481*^9}, {
  3.850559519513784*^9, 3.850559521517284*^9}, {3.8505638507031865`*^9, 
  3.8505638943529572`*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"49922df0-7374-4c1c-8e4e-9f103a17f2bf"],

Cell[TextData[StyleBox["Half triangles of a cyclic quadrilateral",
 FontColor->GrayLevel[0]]], "Text",
 CellChangeTimes->{{3.8505565059770575`*^9, 3.850556533657157*^9}, 
   3.8505593391329474`*^9, {3.8505594920934362`*^9, 
   3.8505595104436374`*^9}},ExpressionUUID->"2e096209-7f68-4b19-9bb5-\
de0d1e0fb8a3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"halfTrianglesOfCyclicQuad", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}]}], "}"}], "/.", 
    "sustD"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8505638875338173`*^9, 3.850563889642337*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"849a5de4-b880-4e5b-8ea8-88ed06a0fc69"],

Cell[CellGroupData[{

Cell["Theorem 6.7", "Subsection",
 CellChangeTimes->{{3.850367662817922*^9, 3.850367681472711*^9}, {
  3.850468046384611*^9, 3.850468047773791*^9}, {3.850468091473277*^9, 
  3.8504680956818314`*^9}, {3.850474108128826*^9, 
  3.8504741118490105`*^9}},ExpressionUUID->"7bcbfcce-108d-47e5-9bb1-\
5b4b0d34cc12"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQlYVVXX+A/8NfXpan/eXvunOb6Gop9DaWYofoGWQymXSuDVwFRUVJzA
IRzJHHCK0nAevtTeTyUVHEooc0S0gBRBUcSAgAQDk6uC3ivn/u+959zLHc6w
977nTrB+z/N9z5vcc/Zaaw9r733W2rvjhFkfTnanKGpOU83/+3D8p35RUeMX
fPR/Nf8ROHPO1PCZkyYOnzl3UvikqLcm/B/NP4Zp/s+jMUVp/7caAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEIau
qsjP+eP2maPJd+7RjhYGABxPTVXJjcKCtMuHsvKVNu4S0PvUYARJqcfGrMeq
cdLQ9HVpGnpl2ctp1nM7V+UnhgVKwPTItAr9O5V/p82PnuE7shtLkG8Lt9BD
OY5UEwBQUNzZ3VVGceM+M7mQ45GH5WkLZ/p+NH3C22+MXRl7/YGUg0Tpyikd
3eok6LUu4Uk9HIMssKVJAZfmyZGv3mpU1yM8ZsWWqWxVVgPtfaaAESSkHhuz
HqvGSUPT16Vp4JVlN6fZIOycmxxhukSQ9WnzPrvYHfl+mz7Gf+zk22nwYOZP
Hw5p2cnksQ6e3xborfP0r+RRPj5dhvUwqqaxh2HJ7ILQqsrUc/+ZuWKyd6C2
xj1bDhnrt/xgQvEj0p7w8M5uL0oWGJr5txP3JVqlSDsW9YKu4fr67r+So1Dy
/PLp/QujfN2Dwq4p1GqlImO8n8eKfYpaGwnTaN7Pf0r6aqfEDiYFXBu6Oi9j
o6e2dw7ZdcbGTYOuyTjRgHofN2AECam/xmxorqqh6eva1N9+h4TdnGZ9t3Pm
oY+bMDsCnosTDt78q8p4JaNKWGe8MDZb9qr+LPxlffwnLzKr6iZr0p+Yvbsi
bnYrWDK7LMrcX3cMfk+7a9S25ZT42B9+Syu4cf3nz9f8uznl+XHw+btE3a70
0mcv6ndmQnxnfBoYuTZ648aYHYn7UlISOPn+ZrEDVtf6rSTh4eXxgXX93N3D
j9+i1XT5lqUDG2uW2IGXH0otTOG5hR6mu1L1FzuZFHBpdDtvlEy2Jl2ClkGX
ZO/o163pqJDL97n+nP/znBYU5dk9obD+9z5epDCCiJ0bDmLGdGFDNSRXpaWh
6evSNPCRXDqn2ZA95rMftgxw12jnufFKuaV6wktm9jfpxyI0gwb13PJLCoHH
YcnsUtCKYzs/bq5b2w4feviWSUpC9ckdo5pSXos3VTzDf7FhiwaZ1zccJSjH
Sp4cXNtDG2HSePH5Cv4flSV6e1Bt2//PbVr99F5iP+0aWzYhuvApXln0jXMx
/2rqHXeQ71sq20nlYdce473Z9ZDIpEA9h9nR6uOb8pcEL6vZt6IDxevi2aEg
cFpujQRlMYh2eWdDEiMI27nhIGpMpzVUQ3NVDU1fm+LwQc8WI7krIZ3TtL/H
VDtB+2FgVrXe6xMec43NKEtmjSqF0aNlXH+FJbNrQiuSNmsWxbr1ao9vb1Ub
/0159WxsXz/tp+dOnb+9g912nyV99ZpRsoM4ffocvGP/Aa42d9oQbem9vE+U
8f6Izjo26XmK8vG/8ED7X4pTByfPWXixBFdatqy2MTt5ot3p/Ei54A/qDxKZ
FKjnME5ZNiWmhC9jAge6IHNbWNi2tByuQ1HY3idpWpZol3c2pDGCoJ0bDuLG
dFZDNTRX1dD0tSkOH/RsMZK7EhI6Tbt7TLUTtB+WirhZzd14v9SjLZnV9Pm9
IxtTwQcyaf7HYcnsKtA5p+a01NWZrOnkY9kmdaqq+nGwIdaeJFXhwab5rShk
OrRbn8ER/GBzakoPMkn8H0fmm2cb1MHo4jEnjuRru3lZPGeLaVBWnhjoQVFu
4w5l1/uRXhqTAvUc1nvaPpHZ0PskTcsS7fLOhi2M0GBxXWM2NFfV0PS1KQ4f
9Fy330mDvZymjezs8PajpzRmrMCnNMQls/peemxLqtO6BBX/47Bkdg2UVakf
ebN19n7Ib2ZbKfpYWR0ErZcuig5GXS97vDD3ZLZjttmZBCWRmPBnv4W8LsEQ
xOR9aEOReV7DZH97vBifI8UXNadGIpMC9RvWKXOkAkkPMxRIGyIr2uWdDVsY
ocHiusZsaK6qoelrUxw+6Lluv5MEuzlNG9nZ4e2HpfZamI/A6TqoS+Ynfx7s
TXVYua+G5n0clswuAZ1+KLQZW2X9Nx59at7q6crdy7UnMlGU7H35Bexb11SX
AztRXt13Xcmr4nMytLJkwxKf55qG/M9JhYM+NbIJSsIbZdVF3/agrB+CRPM+
ak/tGtyIoryHnqm0phxXQCKTAvUcZqYqmDQhFbbIVXS5lDpI2JQQ1zVmQ3NV
DU1fm+LwQc91+5002Mtp2sjODm8/enRLmPCYUp5bulCXzLWPzgxva/keWDK7
GvocXi18J1/R1XlXj546W1aNv4mk21oRTKZgjh1z8/s83nEJrGwuhshGGbPr
5dU7qcSasliD8+d90CUx42QUJZsRW17vY5WlMSlQz2FnqoJJExJhi1xF0S7v
bEDCpoS4rjEbmqtqaPraFIcPeq7b76TBXk7TRnZ2ePsxQFemfZ+QmVPDIwbq
kpnnPRxLZlpVeeanLePnhHZ+u6Ob9qLnoZ8MW50gfs+vqijvVOzXn/qNevdf
7IODg32jN8WeulWsEnxU9WfBpU27V7738X93/aBfU93dRgG9x8VM2/lTCsei
ryo/MSwqcuiYt5jbp7u932Zg0C8PNW+pLv7Pvnlvvte9cRPvQO+oXbsKeATG
kFP5d9r86dNHThre3XALdsvVzEVdrJWixnTT3m3NaSW6siR1jaagT3xbyKhW
LXwDe4/7LPL4DRFriMCcQs/QqtX2XKnvO7+fs7E95bMlmc/DKDNPRrWkPKdG
5zlwJ5CNYBHZ0WI306zc9WID3fk/Z+uTxxtCrLI0JgXqOxVxszT9U2AYkQy2
90maPyXa5Z0NWxihweK6xmxorqqh6WtTHD7ouW6/kwg7OU0b2dnh7QcZ5CWz
+OPaZ2tKz00e+9Jg3/WHdl7MuX37pzNf9vJk/tppdOjlSp7F3sPytLnz3tVG
C7u9MSFw7+mT1wv/uPH96b2Bn/RqpD2iatSXO0o4d06qK6/GLB6me/Dt2WEH
TiVdyS8sSLvy44a9S3v21W4P+vSOO5NZbTzeVWZv9wnSLkIN+AZeVijzokOb
+Xp/fTwtZcJo3WqK8oyMNf9Uiivn07+SR304pKWxgZusSVdq3xPxCbeVxk7M
/JvWfor96dBcz5cCV3569Fzy9fzbvy5dzARLU21bRp3IJM//1V9GrCusW8If
7D/TVRX5OTk5f96zaj2u4cn93KMJvxRXcf6RLsne0LW5mzyItyXYh7vpq16m
eDbKam9/OqYj54nfHi8su1iO9H7Fnd1dZVyv0GEW0MIK89zyS9V0ZcnFzxfL
x4ZPHx01aUC/0NXLfi0TXVvS1dmZhyOjhgb4R8yaFRkkj9jOu9sjivLq6SX+
Y6NHyPtMDkti7h1TPszbuilCLo+ICJwdGRk01fIQRVEBcE2KpJFtRNW9OfeX
zaOGThr3SZ/QkKQ8NjNBVZh7PDLCPyIyMjBqTL/+Uds351WJGpmuuXXt5MKl
w4b5R0RMmPCRf9ByvgqVshJNUFUXHzqyaoTv2KiICP+h4bsSyp7oMiPig+Un
8vQKP8zbsi4oaEnU0P7By2OvP7Aol1aV7Ps6dM2mgmrzv/CUFTlpqN/M3dqy
VEW5R1MzhfIv6p6aNWH4sLkHkxXPalLlHSxjYLBrXCP23jhWr7XxBZx7dEzv
E86fQtELq8vXIV7vRO0csy5QjCAAip2ZH1aWpC5fEeSvkTwkZNSkoVMnJl4r
stbj6F4s3tEkaORo3VnAmMiGwijOSpzPVUk3/LqGvkRgtQ2EQYbM5sjGJBnE
cL2JlYOYMQ3WaUrlMRH1InSaDkbKJXPCjUtjOr281CTglk7bH6i/pZcrc1Zj
t9LkkX46w1kE69LK4tjZnXWT7b7Ld1Y+43lQxpUV+/De+TH+vH+lldcmvsuK
5Rt4PnV7h17+p0tVzEdSFrOPsMRyavd/ZusPkW6y5vL9jPHd2i/fVsxjJe/1
CQ9uHw37V5/dWUZHSdc+Tg3orrej34+kh0zrc3h16JbMytxftw/7sEcj/T96
vjQ2Ztr+X7KrJd9XVZSeGNKX8vTcmv1A6lfjwUawCG+UMZkIFMcp8VigZkv1
8j586ce5/f22pbGWp4vSV7ajZMFh1wSyfhWl5yaPf6F9tzXJZyqZ7R1V9e1F
Ie1X7LVshOL8eWV1zzcO3KlR0xrdW7sFhGSWlyYHdA7clVShezl955cvX3vD
rV2Hb27p+wWWACgmRXyh7UStKtrv12OzponSOh80LPDyA1pxfPuAAUGJ+gAP
5S+HJ8oor0/jygRiNKrvZ0TP/q82Jlt21WlJE3tbnA8gbSUaQd/NPyIf/EJQ
0MkCnUenlQUx8p7f5P6xeanPc/o7FGjl7YV9+35z+nEtm2nu9dnOKrO+//u5
BS+KhNNzlxV/fLOXTCCaxeIpVcGyD/tuTvzqXxY5Wbg1rhmT10/x2a4b+bVJ
Xm4Bey5aDmls7+P3zgR6oeZkodQ7QTvHl1nUCEKg2VmD8spPi7u0m3v0osEX
q+78tunNzhuuWucOUDqa9Y0cuTvzGhPZUFjFSYhTuCqphl9X0ZcArLaBIoYU
NhcyJv4gRjDqWjWIGdFwnaZEHpNML6dJZBZHwiXzsI/9W8+KLTZT2XgRamnn
2pqsyf7sRoO2q1oUUF164A3dV18Pj9W/3ud80GNqTDFn5mxFzsaOul/Ims08
ectsNNEeJM6uQEdN6dc65uJd7Q+qbm016GNcucRymlupyYJ1KzpaWsm4XG+f
oJ6d16Wbr4qNLm8iD4p4tHNJW0Nld+p2IO3s3C6dlycm3XnwRNP1FNnZP4SG
vqpd+7u9PS8662/pvDOtzIser3kz3/3gdoRNUBLZKGMj2K08qAo1W4rq8M9X
Rw1P/sO4WehOIZDxXg9Hl2Rvec2Ter371qumTaXw/Pw2JEdAlMWGto5P1u03
MkU3fWdIm4/+c9HQt8pjw7Wi6m/rxhZAzKToL7SdqI8PrHxlxb7HhjdTjSPW
rXkjOMKkL+gS9oUS4XXba25v9U8sNKpQpSJnbdwnL7lPPp5n+DfJK9H8zb5+
J4qMZLh3dV2nrl2bUFQf35S/dEKd3tVrtn4ixIxCw0J+e2TyKlF3xlfW+ja6
cUZfFtpTV9Z1bN/eInofu8YzE98MjS5g3sCc8MlxoAfb+/jSsoj0QsrJQqx3
XK2JZBYxgjBodtZMA/J392g0Yvdp0w9JNcXLZzRdYkVOHFpHs7aRI3dnAWOi
GgqvOAlxClclzfCLhFPoiw1O20AUQwqbCxmT0FnjjbpWDWJGb2mwTpOWxGOS
6uU8icziSLhkpjq033bdIgqB6WsMFlsuxqc38yWMlMVOYSKljXdyai8eCGwq
un7UnRbO4DP0jOlJV3VLZsr4riW6bNsKbaS3rMl7a3aW6dsWsZwkVtK8YfEm
y1trjV8ieDWSECZat3qx/393XHnprkkjfVqZMoTNdvYMj7zBc9A6LsrTe7T1
ZTS1cxj6b52Wo5wJkhxUxd40J54tRXVot9H8awvjv3i65P38fW94cu4FqUvT
lrbBF/tJeaLPK9uYPSL2XGvz3ATt7fbjQ76+oAvjIRBA2KToL7SdqLWPUz9o
GZOmOx3VUDXepvMTtaG3NlmTzpUuwsxqmr+w6GyRSXg6G9tg1Bgkr0QDNeUp
w/pSHuYysN8RKP0BfSrF6ZGvfHGF7QbK77f4NbL08qw7444RQiiL+w5usadM
vCdujdc+vjy69fxzd5k/PU3c4O1OtVqw6YHZ2COclkWol1iXVyPXO67WZDJb
k5uGaGe1ujJ+XrN2fZJKjIWiS1ZOfdXNiivaETualY0cvTur+Y2JbCi84iTE
GVyVJMMvIs6gLy5YbQNRDElsLmBM3EGMbNSVJMG2ITtNSTwmuV4ITtNpkHLJ
zHlWm/Fi0Ch5VofRkpb/25N+QKCodwMvMzmy9NPM0P7sc4JX5jEZ8Trcw4+b
DB3Gi0ezzQ266q/cv4zTNkjlJLMSz0HWxi+xvCAbEZMls8Z4s2ItI22MPme7
yXedluDeZP0yXPAkbXuhD3vgnrHokeYgfWaRKLAfrheG4+O7wHkItPJGhFyb
qj9mWq75qp+u2vP5P0KiC59iipr7Q4iXfuOIEZtzb8cKAYRMivVC24lanLao
s/4+ETaRzX3c4WvmlVdxZX1rntPztDFIU7QLAYvQFzrr1PyOLXwXxLDbULao
RP3jZesjO3PJYNgvYvb96KykD7voLalxmsHeHF7+UdG+njKB0/VFy5LvTbNM
9BJ7yrTZY9W42rQe2ZQW8/FfC9P7uKNNyPRC6PLo9Y6rNZnMQkYQA9HOzETL
/Kae2oLlk9s2b7cytYjEwyB3NKRGzs7ZLBo5endm4DMmoqFwi5MQZ3BV1g+/
6DiDvlhgtQ10MSSxuYAx8QYx0lHXmkEMuej67DQl8JjEeiF0RmdCwiWz5a3N
WgSWzIinNzP21Bbg+W2BrgDjMGbzZTiveGZLJOPFo4jWxHJyiSFuJYvHLV8i
0ZKZe7Oobu2vwdf/wt9EJRmhTNkx4jmKco6TJ+nze0dqD1JzG3coW6B/MiEr
wstqUcSDcxhhvHokFFkUw9yyxzU66WMeLMY0WlXx/cFpXXrsvo6dHkjnnp1/
NE1pLDb/bQVkAgiYFOuFNhT197Q5244qdOKxvYArC4O+vH/Uc9yXddI3T835
h2am8vznaSIXedqiEllK01e15nqzWu/y9CGFz9KSQr87w/r6G8nTm3ONb8yB
gXy3PYqWxbmlKfqUqffEqnHt72+em7GdrUc2p+z1/t/ftVigML2PM9qETC+U
Lo9c77hak8ksZAQxEO3MejdZsxmJ6VIdkYHe0axp5OilsL/nMSZqg8QsTkKc
wlVZPfyi4xT64oDVNjDEkMLmAsbEG8RIR11rBjHUouu105TAYxLr5VKJzGpJ
l8zc6ziBJTMTMC+68r2XHtuS+ZE+LMSwOMVZMpvViNHiUSzCh1hOLjGwrYT+
EgSMviDzL/8zD32sP4tM+CM+EirFmfeYHQe+PTe7wgYeiOxRs5FX3HtiqIgn
aLDCcA1l7DfZupSButfejgzQZqB0ZwMd6arKooycs5v2rxncrVtkxKkCy9Mb
ScTmv62ATAABkxJrZCNRtT8UuHyQqTWuCA19ceIbTbarRLo4ZryH0ZtN/sa4
PK58IiavRBYSedu0KbKnH3B7W4SyOGZZCE/xek/RGjeHOXqRc6OGqUeuP5Hp
pUbo8mT1jqI1ocz8RsBDwM5GUWFuvYPfjv46JjEtrdIqr4Le0UzAbOTYpaAY
k99QhEpJgbO5KrLhFx1n01dcYJy2QSYGsc0RE1FFBzHiUdf6QQycZh1EHpNY
LzVy+3EWHLlkNl6aodC29fYbSvMH0ZfMvoGXjYY4jCUzsZySWAn9JQiYGITP
dCb6uoVbd94InXVs0vO6N9niGmhsadiUCpE9ajb1w7o1Pnv7M3+ChmnAj9nf
mGGk+6p95lFhbAwhJfPrPW9poJa50zbujD10Jtk0m4AUNqaCX3cyAQRMSqyR
jURVG+qOKwyDTedx+/f+DPM36KNfxA8hsV0lGt48gSMCkJ35WOYTPSlL9Pbg
UorNSeH2tghlcbhXhKe4Q3HUCDVuBqMX56cZtvdxRZuQ6aVG6PJk9Y6iNZnM
AkbAQsDOOuicU3NamjhJ7f2PFyzuxkIEvaNZConeyHFLQTGmgKHIlJIEZ3NV
ZMMvOs6mryhYbYNMDGKbixqTAd1Z44661g9i4DTNlML1mMR6qcXaT3XpsYC3
unHx9hf7zE8ptwvOsmQWXPmac+34xGZID5poZxpOQLhkxpKTSwzHLpmRTGe6
RYDbJMwwnIpGZjqJ0bsekTNnmLgCngh5VJiXcO25sZgG/HDIyTlwMVFh1n4B
50c4pohYAAGTEmtkI1EN0nIm1zAhLpwH2bGdC+EQEttVoj4Ch2Oyx59PxO5r
WSrFeFu+pZB4WVzuVfwpfgOK1riZXszlfZyfZpjex7mPR6aXGqHLk9U7itZk
MgsYAQchO+tR3szYEzb/kw596m7i9Oy8+6bwraU8oHc0YyGFG7nllBK3FARj
ChmKSClpcDZXRTb84r7fefQVBattWOOgCWwuakwG0UGMeNS1fhADp2lQisxj
EuulFms/xhHFJghe0mdLHLlkZo4UIFhPIT9oLJ5sRmy50SoJY8lMLCeXGA5e
MqOkgZssma07xc5wBiNlbfKRJNAZh0OainsTfVKPFakxhvAtgfwR/oAfgawi
fe1YefsVL4IxReQCCJmUVCMbiao21B1XpBOT2sB5sd2zpK9ec0Pz3TarRP1B
BFxv5s8nYvM1LC3JeFueCy/EyxK4BVjgKf5TXMRr3LQoJkCR89hSdiiwOKqR
WC81Qpcnq3cUrclkFjACDkJ2toCuLriduvTzD3QrZ7JgPIyOZgRuI8ctBcGY
QoYiU0oSnM1VkQ2/2O93Gn3FBcZqG0RiENtcfNDTITqIEY+61g9i4DQN5ZB5
TGK91Mjtx3lw5JLZeD2F1cFNHhRa8BqfdmW2+4GxZCaW0/AC51kyGx82Lmv+
5VWu0xuNl8w8x8lWF+SmXLxcwR0IYoTxboNpYLywlKjvx4Qd5fgU18MbioMB
mxlkEpxDP82aM2B7zlPjUrhOEbe4oaA4I/qLhPvMi5jasdUne8GYIjW5AEIm
JdTIVqIa6o5jPq+/ZMFwwEVtxg8Tk9IYAdgeyuMrpRBMHFYGrjfz5xM9+y3k
dcsRUq3vL4YmSl/7acq+ZEM4onhZBvd6Nytu0b5yFdpThjPVjZ7SgVDjxlTk
bOyo8dQvx2cznzJrCzZNTMxXGqtmCBV7mri+1Wp2UCXTC6XLE9U7ktZkMgsY
AQNBO/NAV+1Z2c+d/25iQTA6Wh28jZyZUlqOw7iliBtT0FBESkmCs7kqwuEX
9/1Oo684eG2DRAximyMMerqHRAcx0lFXgkEMnCYLqcck1gu5/TgRjlwya29R
X6f1mzre3ZoskNlEX/l+et/BRwpUFg/yZ7XQT34J6sW+3eLkQ4wlsxVyMjjR
ktno/Gq+L8gmn+YtExNqq28smTWgse6v7/bff1PwBEjj1Tfikhnr/XjoLwsT
cT3sz6w635tN0DAJ9qNv/jS5u353Wp9VzVGK+cClmdQteOlLvY9mTpkTdIiK
1ENZfxPtNrAxRVwBaQZIBBA0KZlGthLVkKPE1TuYEzLrDpPUDPgdRx9l5xKs
axBq53TZgRWnNc/arBLZPVsOGdjTOTh2LfjuTNGPn/pao0tiPmy9va4GBcoq
jB5tfDr6k4OrPRazWXiiEhry9Yyf0oJS48Zq6S6XrDub5eGdnX0M0V/shCf4
QKbuvzUz4VcmnSy0Ri/xLq8mapBoWhPJLGQEdATsTN84t6Jrl6Yh065ZbjPr
TEGWt4vc0YwGG96LgXiHJsxSxI0p2CCJlJIEZ3NVpMOvq+qLAF7bIBCD2OYo
g54aaRAjHHWlGMTAabI6kXpMYr1Q248z4dglM3vzNYPfsNPlPIOJsir1I2+T
YJia8hN+7M1PXHfPaaHvnFvwT3ZZPXLryWrTd2Mtmcnl1OFUS2ZWSB1eizdZ
fPVj91G1eHgsu2h+0HzdcV7MTwQPrmQDinCWzFjvx0N/WZjI9dACty6iw7gt
r95JJfp/0V6V2FH+nf7GQzYlimMoY0Jc6jYrnlamjPDaYrhQj9n15Y/RUqUn
hfSQX7hHtGQWjCkiF0DYpGQa2UhUtdAtgcxGa93BL5W58d6DUsr0P2MCkHgT
EGjFsa1vdg+6XEnbsBIZ4S36Gp13fuFL2sbPkZLA1o7FMMj2F31cjca7+bbc
lG3Uc0TK0ucuaSNbWkae+hPtKb0PMntKjVbjdTBLoboN1dqzuzvNjqtg7M1e
e6SPNnl4Z1cvo5Q0Mr1Eu7yaqEEiak0gs7ARUBGws96V+Aw9Y3HwDJ11fKKs
2aJzdzGL04He0QzwNXJmEcQ5pcQqRdyYgg2SSCm6suT8hmVbT6UpyKOhnM9V
EQ+/LqovClhtg0AMYpujDHpqtEGMbNSVZBADp6nFCo9JrBdi+3EmHLxk1u7C
ZG95zZP5e9/oZXmWR/pV38+IGPv/nnvpswtFNOeDsqYh/3PS3GsoSpNH+uny
pdz8Po8vsUjQwFsyWyGn2tmWzCamazY9IdXYdKr0YxHMcV2cVjVbBVMiCb8C
J5bzgfV+PJjRQ/TzMf+tixgwbtdIZWXa/gFjovMes//JJoZwOUHGaAYhlSlb
vKJNdjYeH/rKt7H7uMMWowqtqjyy6/2ew5P/ILzfji9G0QxsAcRMSqCRrUQV
vCVQN2jULfwr4yO8dpw2ijmhi2PGubt7rP71vvmTtLJk95rBveSG4mxVicyd
bmZXNBr6O/edcczSxnRDg1YWr573WhOZYTiis5J8e5tuTnKWVX5zV79evV72
rBtX711Z3cto0cQj4ea+gk8h17ihGO2lZoZ5o7LqwuieX13Vb2Uys0qDamnf
eo0zytQj00usyzPg1juq1gQyCxsBFQE7a+ZgXVuEhX6XmWcel6WsujTG5/m5
caTboRgdTQ93Iy+ImfKqG9+UEqcUcWMKNkgCpar/TBzAdGquR9BxMldlxfDr
kvqigdc2cMUgtznaoIc0iBF6EykGMXCaujLIPSaxXmjtx5GoHuZsjTFi3zeB
Y1sZLVB850/budPo798kFHNGlLPvMXm81djAb/bFxGzclKMzc23OxY0x69cv
3j6r7hctI7do37rxYo7J1Plhedrcee/qTnLu5N9/xd74lMy0gsKi68mpP6yI
n9G+SZP3/b75rUhlmZBeUXRq4uRejTRtosmQeRMP/HzyeuHvv2dcP7dx79Ke
fbXLI692n353ssK4Zh+VXlirEWH/Rl9fvViNQtcuXr9eK1jijXtC1sOVUxIr
IbyEAE132/vOex21i1O3N8aN/GJXbOzSnetGTWe0k/XvvvrkRe6968K0mJfr
Gkzf2H0K/pUle/4eswTnOnzeyvcjQ1cX3Dk3LpjZDPDf8l0lf5a0yHXtqAUq
b0TI3d5i3C5dffn76W+a+Cn2SA3O3F7dVfJMAIzqTubad0aYB+MpFVkzQ5p6
+50o0r9Q4wpTz+8ZPWDAstjr5Df6msUU8YMpgLhJcTWymahqwVsCa8/uHfkc
u4FcnXYkeGjkDbNdIO1O3cBGIWEZf+l34VQ1ZSkpG97p/v6aOJN9NhtVojYa
9mz0K+4jNiXp+i9dnX52Zf8+K1fO06aW8HynoPPTYtq4NQ+PLmBkUT7MWx01
YM1PvyyZ8kpjjQ99ppE2c0KXiJ/MA97My7p6cb1Pn9hzxQ++08zZdNFW2lXJ
qC6mM1tOCUWeQq9xPVU7Fr/cRHdCu2ZWuXHmoB0mG4CV8fPbNdYFWKrun5Z3
WJpqEk5DopdYl2fBqnccrQlkFjYCIgJ2prN/nNR7+NHb5ca+W1WYmxj8TucF
y6xp5BgdTY95I6++f33lshH/0O7p8k4pcUoRNaZwg8RWyujyC6tutXAuV2Xd
8Ot6+iKD1TbwxLDC5iiDHvIgRuZNJBnEwGmqrfOYhHohOk0HYvw1EwW+L4MC
79FvRJh9vzb5CddHUtWfBZc27VoeMHlktw/6NdUsC1v4BvYeFx22OSWlrFqg
E9DVeTdOxW5YPCx0UJdhPTTLZ8+WQz7UPfjD0TsPLD4fM5EAPKC4Hgw5JbES
wksIUVUXHzv21cdzQju/rVs7U518O42aHrj+8HfFQglmtOKH/53Tubfb/2vx
/uKFIok5SsXVeTO9m1Kd5H57r/GFs1vxflGYiCZOeMICzU45IEdRem5WeP/R
I6dN9Y+I32zm1Kr2rur0sufai+YBCTroisRd4QN9ZyyZ/PGnC9Pucg0gmrpL
2B89eMCkyFEhIRFB/vLl2+MuFFvjkrVZ5BljB7m/MyilBEFzHAGQTIqlkc1E
Vauf5c4LaOkzYP9trutvamsK4pcHDBwatWRW8Bdfcs7M1dV/X9+8NWKQX8S8
wMBAXXHf7PjtLtdPbVGJOpQ3M/eOCe4/UR4xyT9o+bJfy5QlMeNkgifaKW9m
7Bs7obevptVNnz465OvTmdW1uqnXsnnvvek7I2Jo+LfJnHtoFmXpmqvWUKtG
9faeHDVs2LodJRbDMPZTWDXOlqHIWjyl/2j/6NmBcw+fNhdeqbi+epGmKsPD
5QuPWPyVTC/BLl8Her1jao0ts5gRkBC0s2aBfHxuZCDD9LlzP9IIFp2ck19t
/UYoekczSGpo5J9GyOWB8afzfv5IO6UUukABvRRRYwo3SNziHhYdk7//QpdO
kz7oOP8s2jXlfDiRq7J6+EXBifTFAavBY4hhnc1FBz2cQYxk1JVkEAOnqbbW
YxLqheg0AQBwRpiEjrrzIQGrAZM6GvbUU56LEQGgYcKEBXIHXroI9NPMyQMP
cC7vAAAgBpwmAACAMDWlB/vIOK6nB4gBkzqcu+mrXnbMla8A4LQweUN8x4e6
Bvd+WxRg1SXFAABwAE4TAABAGN25fx5TYRIiHWBSR8Mc9Fp3MSIANCTou/nH
54YuMA81rL0dGeDm1mzeKex7tZyHis0fLLxsxdlfAABwAU4TAADAHG3iSVT/
0aGnirVpF4/2rujm7tqTKMcDJnUyymPDZZKk5wOA68HevGx+MEtp+qrWlNen
xKd2Ox664MLoiS4sPwA4LeA0AQAAzNAdCKmZTrnPTNas6Z5mhnq7j4t0oiPu
XRAwqXNR++jM8LaQkwU0UJSVJwZ6UJ4vTdl/uu54TqUiY/ywZuMjrD1e0oEo
Sn8IDThc4EynywJA/QCcJgAAgAW1Z/eMaMYeza1KPzqpXY9vb3GdGwkgAyZ1
ImoUxd/tmdCCoqjG877PrYENc6DBQZesHPLGnlTDGd3S3HLlWKrvp88etPAc
HPsFAFIDThMAAIATWlWyNy4wcPqs4Mhhn4Qm5d2DSYi1gEmdgdzkCBnX1Woh
kbctbq8AgPqMUpGzdrFcPiokZMKEj/z950cezsyR4JYrh0EXfj54Zkq2EgZW
AJAQcJoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAACAjaGrKvJz/rh95mjynXu0o4UB6h8u3cBcWngC
XF1fV5cfAAAAAAAAcCpKV07p6EYZ6LUu4QnMMgHpcOkG5tLCE+Dq+rq6/ACA
hOLO7q4yqlUL3w+7GfHhkJadqF7eJ8rMfq26FvbfMk1/kDXxDmB++e67//Jp
3ejF+BylQ8QHAAAAANeErsk4EfWCxqc2mvfzn44WBqh/uHIDo1WKtGOuKjwB
rq6vq8sPAIioaip+/v7TV2TMBpFsmN//ZmQrOBfBqpqyPV+995z2Z53kvusP
77tWkF8Fy2UAAAAAwCX/5zktKMqze0Ih+VcZuiR7R79uTUeFXL4voWRAvUCK
BuYwCs8t9KCoDp7fFrig8AS4ur6uLj/gajjQ95XFTvHQLZnbxux8xN/e6azj
E2VNx8TvLamxo3AAAAAAUL94cnBtDzeKCpyWa4U/rdm3ogPlsssiJ4a+cS7m
X0294w4qah0tCimSNDBH8eyHLQPcKUoedu2xo0WRAtHm5Or6urr8gAFXGfoc
6ft+P7fgRd2auXufpBKe0hWlyf7t5btOKp7ZVzYAAAAAqFfQ+ZFy61P/6ILM
bWFh29JylLBilpLa3GlDRD8iODfSNDAHwQrvyvY3RrQ5ubq+ri4/YMBlhj5H
+r7ax5eDvXVrZrd/78/gKF/5MGtqj347YL0MAAAAANahrDwx0ANS/5yUmtKD
fWQU5T4zudDRopDi0g2MFd5t3KFs5562oyHanFxdX1eXHzBQD4Y+u6BM2TFC
l6dMfRh27ZHp32hlXvQH7T/bUa5yjGwAAAAAUH9gUv8goNo5YbKA27b/n9vO
HZsogEs3sNJLn71IUR715XRZ0ebk6vq6uvyAgXow9NmH6tIDb+gSmmXPf55W
WffvtLJkw5zO8+MgfxkAAAAArAdS/5wZl84CZnDpBlZ7atfgRhTlPfRMpfiP
nR/R5uTq+rq6/ICBejD02Y2KuNmtdN+ZW82Lq2A/KNOKpA09Rkdk/e2CG5UA
AAAA4HRA6p8zw2bzuWYWMINLNzC6JGacjKJkM2LL60MmoGhzcnV9XV1+wEA9
GPrsSHFaTEvdmtmrR0KR9qO88uy373SVX7gHtgMAAAAAKVBV/Ti4FeSLOSlP
7yX2k7lqFjCDSzcwVnhqyK4z9SE2VLQ5ubq+ri4/YKAeDH32hFZem/guc0Hz
u1uTH+X/OP3N4cl/wOd5AAAAoB5AV2dnHo6MGhrgHzFrVmSQPGL7rgKL73DK
q6eX+I+NHiHvMzks6ZZuy1j5MG/rpgi5PCIicHZkZNBUi4M6VdXFh46sGuE7
Nipy0lC/mbsTyp6oVUW5R1MzOc7MvJu+6mUr8sVoVcneuKCgJVFD+wevjS/g
j7ylK0tSl68I8teIHRIyatLQqRMTrxWprN8Cx1IWARKDo1Wl4cc1t66dXLh0
2DD/iIgJEz7yD1q+7Ncyo7mN4s7urjKKD87wZhwjKHN/2Txq6KRxn/QJDUnK
Yz9CqApzj0dG+EdERgZGjenXP2r75rwqsbrRFJqwf/GIIfKJ8ohg+cIjpzVl
qYpuHMvIqTZuSqgNDMuGwm9Slh3cHBq4aNFweZ85Cy3jEunSGwemhu7ILK77
w4PCox8Nb+kzYP/tapOfMsJTzy2/VK1pwBc/XywfGz59dNSkAf1CV5vWmhVK
SVYjnGA1J7voi49Yl5FOfqOCoiKH+QasWHax+IGAAvjDmhM0CS6pUC1sU/kJ
hj40kYhGdVGbOdr3mZWStj+wic5QPn7Du/fccrUcPjADAAAALo+i9Nzk8S+0
77Ym+Uwlc0qNqvr2opD2K/ZWGq9x/ryyuucbB+7UqOlHZ4a3dgsIySwvTQ7o
HLgrqUL3FH3nly9fe8OtXYdvbunzl+7mH5EPfiEo6GSBbqZHKwti5D3jj2/2
klGtWm3PNT83k039I8szpZXF66f4bNfdXqE9dcctYM9FznWR8spPi7u0m3v0
omEFp7rz26Y3O2+4+gC/VKPyMZUVB9/gqFXJUH0/I3r2f7XpHXcm07CurE5L
mtibO4IOJZsPzwhVRfv9emzOfqCZI6fKO1DDAi8/oBXHtw8YEJR4o5iZxSl/
OTxRRnl9GlfGbz+6JGfP2282Gzfx0l2dZLp7TAK2JK7tqHmyd1JJ3S+RGhiW
DUWgy7fMGLD5B21Lqy76tgfl9dnOKpNGWXs7MkAzL/fZkmx4N5ttbfF1khW+
l/fhSz/O7e+3LS2bqTW6KH1lO0oWHHZNYbVSEtUICqiJzDbVFxecLmOV/NqC
ovq19Fx+4rRe/pqC1XNfeKH7Vp7VB/aw5nxNQq84moXtKD9qIjOKSASjuiiO
9n0cPClL9PZgbpuC4+IBAACAegBdkr3lNU/qdYuZWOH5+W28T5TV/UNZbGjr
+GTd1rfqcmAnStb0nSFtPvrPRcNRsOWx4dpN+U6dv71TW/dmX78TRUbzjHtX
17fROdI+vil/WciiS/0jyzOlMxPfDI0uYIpiTkUOjym1nHTcz9/do9GI3adN
P4XXFC+f0XQJeX4rvrLiEBocoSq1KEqTR/q5vdU/sdBIYKUiZ23cJy+5Tz6e
ZyGOeDYfrhEeH1j5yop9jw0KUo0j1q15I9j0iJgnfx7sLXTAta7QV93kQZcr
jX5Qmr6qNRMXGHi5yui3Yg0Mz4Zi0Ne+D+g3LZe5aaXq1laNisNCfjO+eIW9
ucY04FNReuRtL23Frkswar+s8FSHf746yizKkWkesjXpD61USpIaQQM1kdmm
+uKB12XI5WcLes1CfuYsYu2iz+IRzGHNKZsEhoXtKz9SIjOiSLijOgqO9X18
VO1Y0tlNOwZ7zIqVYC8FAAAAABzI/fx9b3hSsmYzT94yd5ilaUvbGH2he1Ke
6PPKNuYroe57mQbPyNgSo7tT6ILMbeNDvr6giyirKU8Z1pfyeGHR2SLTqGHd
Vr/Gjc6JqzD73GNNnmnt48ujW88/d5f5r6eJG7zdqVYLNj2wmHRUxs9r1q5P
UomxUHTJyqmvunGJhAiBsqLgGhy9KtX6qWlzc4HZ72KcKXucizuTH2AaofZx
6gctY5hbSPRZn5S36WxZrZ/NUk3WpD/hKLSq6IC3J+XhsfrX+yb/XvvozPC2
msdM2oBoA8OyoSjahL5Xwk8WMK9ibWv2oYq5ucZirs404OADmXX/ajBRh3Yb
zT8JMWsBauzhHKuUkqRGEBFtTnbQFwvcLkMsf035z3I/Nzcu+dnD6zgaMN6w
5pxNAt3CdpZftK2ii4Q7qqPgWN/Hh1KRMd6fjWvHWf4DAAAAgNNBK29EyLUH
uo7Rfwgz+lvVns//ERJd+FT/D7k/hHiF/MZ8FWHm+R3ab7tereaGLlsf2Vnj
iKfGFJvdR6pfy8j3ppnPCO7nbGxPmshcnLaos/4mF800KaC7ZmIZftxi9sLM
mszvfKktWD65bfN2K1OLiDbaiZQVBcvgWFWpDZae8iqXwHTWqfkdW/guiLlh
+fmLZ3FneBTbCMZVxmZ9uo87fM387RVX1remuCPbaVXBwnEeFFeh7PTYNCZQ
uIFh2RCF0vTPvfQf1vXn4ZjFWj/au/y/3Cjq48h8s6m6Nrqy8eLzFXX/wgiv
me+vT3hsZiOBs4mwlLK+RtARaU520Rcdgi5DKj9fQQylMWMpyzAJrGHNOZsE
uoXtL79oW0UXCc+NouFI38eDUpE1893OX6aeH8ceAtZ/49GnmAUor/w46zV5
6n3xXwIAAACATaHTD4U2ozjcK62q+P7gtC49dl+v+zhC556dfzSNmcuwiV2W
83wDbFgsl+NmZpIeL8bnmM8I6fN7Rza2iFxF1OXmuRnbjyqY1cjv5xa8SFGv
9//+roWTZr4myJrNSEyvlmrbm0hZUbAMjleVN0/N+YfGCM9/noZxWaxINh+B
EX5Pm7ONrTL2QxJXxCl9ef+o57hvtmUV4Vx6MNNj0zmwcAPDsiEKJm2SsY/5
nLz2WpgPZZrIzHIvfUU7kyk6K7z+0hYTtOtr7q0APKWsrhF0RJND7aEvMgRd
hlB+tqBmi/QfDU1hI4TNw25xhjXnbBLoFra//OJtFVkkPDeKhiN9H7dAypIN
kT0Wx5fUGCxDUb7+F/5GfsGDe1c3xH/yoowsoQkAAAAAJIU9d4jqzkZq0VWV
RRk5ZzftXzO4W7fIiFMFfEezstM2jnk+C10cM97D6M0mf2NmklyTk4q4WR4U
d0QZFhVxs1vxvYd+mhnanzmTpHfw29FfxySmpVViL2dN3kimLA6iBseqSv2P
ceYwYtl8VhpB6K5kplVwZcPpC+WaVrHTY5NEZuEGRtwdkGC/JpvNuh/e2a1N
WTb9msxwLWloD5MfM8JzTrDZ48Le13+9kkApshpBRzw51L76ikhL0GWskp+v
IH1osflFzxjDmnM2CXQL219+0bZKJpLoqE6CfX0fJ3TVf1Z2CI1kQwKeVpx4
WxcMTzWalVwg2vvoX5PCe3brNsg7al3clH8SngECAAAAAFLC5mdRMr/e85YG
apk7bePO2ENnknP/ErwsRGCeb/bmCRwxkLzLFjZ81+rTNZmDOvm/VtA5p+a0
pIyR+fSOQ08cM4NMWSzQDY5SlcwhVLhnrCkrTwz04M3ms9II7Mu5Uoz18dX/
3p9hLuyjon09dYVOiSmxCFhgTl4yKVS4gRF3BxTYaEmL+3lzkyNk2hOVLQ+k
erRzocdqoym6Prid64Zfdu7dfdU+8wBgYqXIagQd4eaktru+whB0GTL5RQvS
B3u/vuGo2ToLdVhzziaBbmH7yy/aVslEEh3VCbCz7+MqQXFsS8+AiVlGmwTs
biFn+owATJOAJTMAAADgcJjgQII0W/55PguTosU5XRRYtjCzQSsTJNX66yAF
v1Yob2bsCZv/SYc+dZduenbefZMooYxMWSxEDY5VldeOT9TFEOKdscacwsr1
EVmLlUZgXs6ZKsi8mfP0GMYsnIUKJDLzNTDi7oBCcVpMS46iH+1c0pbzQ6T2
e1DLyFNGU3RGeM4zlpm5Jec8mVgpshrBfT9fc1LbXV9hCLoMmfxiBbEBGzzL
N6RhzTmbBLqF7S+/aFslE0l0VMfH3r7P8uWZP0x6bVjKH6bx64YbE7CytmHJ
DAAAADgJmYc+1rhX6rnllwQuB+WAd56vR3/AKdeb+ZctdMbhkKbmkbT4sDFy
aIeN0NUFt1OXfv6BbvYgfIEIb3lEymIhanCsqnyW9NVrbthSsaGkPDJYaQT2
5Vypgg82zW/F83lCf3kxV6GciczCDYy0O6DA2tz8Mmj+ROaqm5t7m8wV2bWS
QAg658VDpEqR1Qj2+wVy8+2rr4i0+F2GTH6xgujC6NEI0cuCw5pTNgkMC9td
ftG2SiaS+KiOjb19n/kb8y8u7Mp5VoA+cJ3zKDw+YMkMAAAAOAmMo+/ULeEP
rMf45/l6VAnrtEF2XG9mZ5KGZcvdrLhF+8p1syRm3mKIpH2auL7V6gTspWZF
zsaOmre8HJ/N7GbXFmyamJgvPJOjq/as7OfOc5GlGGTK4iBucKyqZAXGm4qw
aYAmMtBPs+YM2J7zVG2tEdiXc0zb9HdCGQ7Vqc34YWJS2jNjRbgK5UxkFmlg
hN0BBbooOlj7jWXlvhpjBdl7bTgiM2tPbXtlqklaJRPczhWCzkb51s2TizOi
v0i4/8wapQhrBPf9fM1JbW99RSDoMmTyixSkuLO7q2bl4SbfdRohkpZnWHPK
JoFhYXvLL95WiURCGNVxsbvvM3lRSfbmvh1WXrI8dEz316xjk57XrZl9hp5B
jEOHJTMAAADgJNxLj20p4ugVqYey/jb1gUwGFmfAoR52W9438LL5T9ivJIZl
y5ODqz0WM8lrz34LeV3jUfUX0Womlq9MOol9OzNzJaUsJPL2E1banX30R7Lc
OLeia5emIdOuWX4K0JkCL7dXD5GyOCAYHKsq2TUsh8B1kpcdWHH6rlGMIpvN
Z7K4o2/+NLk7+6XMKiMw+XecsaY3kqc3Nz79VTN97Tj6KDuzRS+U+blIAyPr
Dkiwl/CaXLJsKLGD57dmh+LQTzPHvjL/rNGByfqLrTlC0M3nyepHOxe89KV+
OUamFGmNoCLWnOytrxjYXYZUfuGCHh9Yp1ndyILDjEcw7GHNKZsEsoVpe8sv
2lbVRCZFGdUxsb/vq0NRcmRwh/kp2bw7OSrFmfe8dGtmrisVOIElMwAAAOAk
MLvr/LFwqvSkkB7yC/dM/RuTgSXsyJjUMIv5D513fuFLVF2GqXHCJnv/RfMv
r+q27h/e2dWLIDOO2bqvO8Wl9uzuTrPjKrT66S9n4drlprOOT+S91UUMAmWx
QDE4VlUykdK851fTimNb3+wedLnSqN6ZOaFX76QSw6+UNyI6yr/TX29qjRH4
7zxlvgvXnZJUmRvvPSiljDZ5kLdQ09RC0QZG1h2QYNve2MM5JnIy169YzLQ1
E/JJPU3PUmazXzkm2Mz39LpT155Wpozw2mJIGCRTirhGEBFtTnbWVxTcLkMs
P5P1yXmfWvGVdZ1k1Ovdd5kEvuIPa87ZJNAtbGf5RduqmsikKKM6Ho7wfQyK
0mT/9vJdJxWC38uZDR+K54hIDtCXzA/vZW6LjT2aXC5ZiDsAAAAAmPD40Fe+
jd3HHb5mPo2gVZVHdr3fc3jyH+Z5X0wGFlfAoRHMlrLp/IQuv7mrX69eL3tS
VJM16Trfdu/K6l56J87MOvTLBzrtW69xBJlxus95hqmLsurC6J5fXWVmmJoZ
RdcWYaHfZeaZ74Qrqy6N8Xl+bhzh9SgEyuKAZHC8qqSLY8a5u3us/vW++Vto
ZcnuNYN7yc3rnZm9GC1OlWn7B4yJzjNk5lphBIE7T0tjxhp/GKqMj/DaYRSS
yhxDbTYNrio64O2pnZmZXQON0MAIugMizHTRJCi0tiYrXN62eSdzOZWKjLAe
kaeLjGVgs7C5FhRMRKvha6YyZYtX9KYKo7krgVLkNYKIWHOys74I4HUZK+Sn
C6P/7dbcoiDNqmSkn9tr3bdeLTfVi2RYc8YmgWNhu8ovOvQRiYQ4quPgCN+n
0a8093/f8XP7IOwa1033JjDxFdqR+R9fXhH9NfKSuab8hB/z/Zr/SHMAAAAA
sBKlImtmSFNvvxNFeoeucfGp5/eMHjBgWex1y8sk6Se/BPXiDjg0++GNs9Gv
uI/YlKTbeaarr15c79Mn9lzxg+80UwtdkButLIgZ1cVoclIZP79dY128our+
aXmHpancWVHCVO1Y/HITXaSrZqK1ceagHXVb33T2j5N6Dz96u1xl9F5VYW5i
8DudFyzjUBYZAmWRX41qcLyq1M7ABzYKCcv4S78vr6opS0nZ8E7399fE5Vne
i6L9sCJ3e4tZAtDVl7+f/qb5JJDUCEJ3ntae3TvyOfZQneq0I8FD9Xd98hf6
xYAeixfM0N5pYrFgEW9guN0BnZryn+V+br37/OeW7i2axrkhskfMjuLsw2Et
qL6L40qYApUP81bPMG60DOzxRHPiKiy/4/x+bsGLbMi36k7m2ndGmETUkyhl
VY0gIdac7KsvGjhdxir5zQvSturtA7t7TAg7VcghPcmw5oRNQo1jYXvKjzD0
YYuEPqrjYFffV6P4My3j2PxV//6H7lgv7/4Hbpq83Az6wb2rX3357+b6I7on
TUsrKK4WVh5xycyetc5zBD0AAAAASIWqujhhf/TgAZMiR4WERAT5y5dvj7tQ
zONEa6szxg5yf2dQSom4q1fezNw7Jrj/RHnEJP+g5ct+LdPNJWprCuJXjert
PTlq2LB1O0qMI6mUiuurFwUMHBoeLl945LRwlBd/qYqsxVP6j/aPnh0497D5
SzSThONzIwMZps+d+5FGsOjknHwR341SLK6yiOAYHK8qq/++vnlrxCC/iHka
W+h+/M2O3+7y3yKqKD03K7z/6JHTpvpHxG/mWFYTGuFZ7ryAlj4D9t/munxE
++xyTZOIWjIr+IsveQrN2DcuYOikoMiIcPnyZReLHxfrbmTmWLCgNDAsG2Kh
Nfi2SJ8+8sny6IiRgZv2Mctkrfxjx779pu/4qMDA0JCvT2datsaqvas6vey5
9mIRlxh0ReKu8IG+M5ZM/vjThWl3uT6h4illbY0gIdic7KsvMshdxlr5tQVt
CRvuHx09NfyDgKGzp+3/JVtgjCIZ1pywSahxBiV7yo8w9OGJhDWqo2Mv31cR
N9P9Xy2HfNBNx8j32zCXUjeZfjKf8/e6Qyfcer/XtU+fbnp8fLoM69GI8vps
ZxWfAKhfme/9PMb/hS6d5h5IJpwzAAAAAAAANDTY829tc70yAAAAYAfg+C8A
AAAAAAAbwdzIbJYgDAAAALgQsGQGAAAAAACwDfrbavwv/O1oUQAAAAAyYMkM
AAAAAABgC2jV7TnBMspNvovgzF4AAADAOWAuXOvOXi0NAAAAAAAAYEGXZO8c
6N30zb6HC0wuR1GmaQ+g9giZmCXFeV0AAACAXSn59Yt+3bp1C/JtIdOfr607
amzQoCMFkp6WBgAAAAAAUK9hbjWlXu+Z8Lt+yayqLt67Y9w/mw6Jjq67pAYA
AAAAAAAAAAAAGhqK0tQlCwIWzN688LNQ7aUp80L9/GaujT6WlQ/x2AAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIDT8P8BsDJ/HA==
    "], {{0, 99}, {1297, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{1297, 99},
  PlotRange->{{0, 1297}, {0, 99}}]], "Text",
 CellChangeTimes->{
  3.8504762697218065`*^9},ExpressionUUID->"abde8aa8-3224-46f9-b3a7-\
cb77b4a5bbc6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Incentro", "[", "#", "]"}], "&"}], ",", 
     "halfTrianglesOfCyclicQuad"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"RectangleQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8504746295601993`*^9, 3.850474697159972*^9}, {
   3.8504760047470555`*^9, 3.850476005001328*^9}, 3.850476220298831*^9, {
   3.8504891564394875`*^9, 3.850489157234827*^9}, {3.8505566517266316`*^9, 
   3.8505566557945347`*^9}, 3.850559612034687*^9},
 CellLabel->
  "In[147]:=",ExpressionUUID->"5e542af9-d35f-4dc5-b94c-89f6258492ff"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.8504891591643243`*^9, {3.8505566310755415`*^9, 3.850556659347351*^9}, 
   3.8505596288743253`*^9, 3.8505641280621395`*^9, 3.850913225562418*^9, 
   3.8509186477297344`*^9, 3.851255533704342*^9},
 CellLabel->
  "Out[148]=",ExpressionUUID->"d49c947a-4880-4d79-a4fd-dbec3287807b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 6.8", "Subsection",
 CellChangeTimes->{{3.850367662817922*^9, 3.850367681472711*^9}, {
   3.850468046384611*^9, 3.850468047773791*^9}, {3.850468091473277*^9, 
   3.8504680956818314`*^9}, {3.850474108128826*^9, 3.8504741118490105`*^9}, 
   3.850476924842958*^9},ExpressionUUID->"44dd518d-9e65-41d5-a445-\
6759050a115b"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQlYE1f3+J/4rxWepvaHffWt1bYqLtQv1hZQC+prwAXEItiKCyKKKCqI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    "], {{0, 184}, {1111, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{1111, 184},
  PlotRange->{{0, 1111}, {0, 184}}]], "Text",
 CellChangeTimes->{3.8504762761093454`*^9, 
  3.850913074858418*^9},ExpressionUUID->"9d9218fc-ed17-40b5-b990-\
3148f9e24f84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Specify", " ", "a", " ", "center", " ", "function", " ", "by", " ", 
    "giving", " ", "its", " ", "first", " ", "trilinear", " ", "coordinate"}],
    " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"centerFunction", "=", 
     RowBox[{"convertToABC", "[", 
      RowBox[{
       RowBox[{"Cos", "[", "B", "]"}], "+", 
       RowBox[{"Cos", "[", "C", "]"}], "+", 
       RowBox[{"k", " ", 
        RowBox[{"Cos", "[", "A", "]"}]}], "-", "1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Multiply", " ", "the", " ", "1", "st", " ", "trilinear", " ", 
     "coordinate", " ", "by", " ", "\"\<a\>\"", " ", "to", " ", "get", " ", 
     "the", " ", "1", "st", " ", "barycentric", " ", "coordinate"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bary1", "=", 
     RowBox[{"centerFunction", "*", "a"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"center", " ", "point"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ptX", "=", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"TernaCiclica", "[", "bary1", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "verify", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"Factor", "[", 
          RowBox[{"Simplify", "[", 
           RowBox[{"CentroETCTriangulo", "[", 
            RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "]"}], "]"}], "&"}], ",",
        "halfTrianglesOfCyclicQuad"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"RectangleQ", "[", 
    RowBox[{"{", 
     RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.850478455227113*^9, 3.850478458887106*^9}, {
   3.8504787093911257`*^9, 3.850478724430688*^9}, {3.85047910670671*^9, 
   3.850479153913602*^9}, 3.850481081635483*^9, {3.8504815360741606`*^9, 
   3.8504815474586554`*^9}, {3.8504826439852543`*^9, 3.850482658768121*^9}, {
   3.8504830738064427`*^9, 3.850483096474668*^9}, {3.850487953134947*^9, 
   3.8504879649689045`*^9}, {3.850489186520263*^9, 3.850489234389205*^9}, {
   3.8504892662272263`*^9, 3.8504892852722254`*^9}, {3.8504893452400455`*^9, 
   3.85048934598949*^9}, {3.850489382551634*^9, 3.850489440891324*^9}, {
   3.8505567214369793`*^9, 3.8505567248021946`*^9}, 3.850559694291537*^9, 
   3.8505600196329556`*^9},
 CellLabel->
  "In[149]:=",ExpressionUUID->"9df1baba-90ee-4cbb-8cc9-3e06d70befd6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.8509132598961306`*^9, 3.8509186715064497`*^9, 
  3.8512555541597137`*^9},
 CellLabel->
  "Out[153]=",ExpressionUUID->"2671de3d-1d2c-4308-ae64-d1e2eea74939"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 6.10", "Subsection",
 CellChangeTimes->{{3.850367662817922*^9, 3.850367681472711*^9}, {
   3.850468046384611*^9, 3.850468047773791*^9}, {3.850468091473277*^9, 
   3.8504680956818314`*^9}, {3.850474108128826*^9, 3.8504741118490105`*^9}, 
   3.850476924842958*^9, {3.8504828736251273`*^9, 
   3.8504828747294316`*^9}},ExpressionUUID->"81ed3610-9950-4643-b4fa-\
fc52902f3e6a"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztvQlYFEe3+D34uT4Z40fymuuSuIQXJV6XxDWouYGYKBoFTUSiAaOiuOCG
K67EuOAWEg3uy5uob1SiAZdEiAZ3YgJEERQXDBIgggEjow46I93/6enuoXum
l+qe7lnk/J5773Mj012nTlWdU6f6VFXrMdM+iKil0Whm1jf9nw9Gz/WfMWP0
vA//f9N/BE+dOXH81HFj+0+dNW78uBlvjvn/TP842fS//1NHoyH+fxwAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAqWEVZXs6fN08eSr51F3O2MADgWlRW
FF29nZ924UBWnkHN4QHDkAT0oBLPtmKf7drxUTNr7b5AexE4yqU6k4q8xPBg
BZgclVZGv9PwT9qc6Cl+g9pRDPN73iPsQI4zqwkAjkR3a+drWg03taYm37b+
/YPStPlT/T6cPObtriOXx165r7y5KV4+obVHtRCd1iQ8flZtmi3qqxdwax5/
/+WbtatHh+e02BKjKgXV6GHIAPSgEs+2Yp/t2vFRM2vtvkB74Q50qc4nNzmS
PdnXdnn5fSr8HfT+y12Yf/Ty8+rTh/zTB30be7Eea+W9J5/uKE/+Th7au3fb
gA4MHY48CEG024IZy8+d/u/UZRG+wUS7ezfuO9J/6f6EwoeKmwZM992XfRq1
/k+uAennRn3hkWObRkcN7zCkR30NIViI74Q10Yczc/RVSosmA8yoSzs8o5F5
APj57b2Yo+Os1pN7Z4f61RoWflmH4wZdxmh/z2W7dWrIXy1P7dk//6VCAS6J
w9QLuDeY/kbGem9isPbdcVLNDoJVZhytccOQA9CDSjzTiq2ZXqxm1tqNeabH
ICoOc6lOJfPAx/XI5RLvhQn7r/1dwYyLjAlrmKGyVSBs/Ov2r2vjP3mRjLPr
rUp/bPXusrjpTSGIdnMMub9t6zOAWFh7pfGE+Ngff0/Lv3rl589WfdRQ4/1x
yJk7yo0Moz4/fvUQLXdf4hDs8vmvevmZfq7t2X7J3u0Z1/Pz0y4lL4z96AXT
v3l0nRh+uqhSMdlkQy9SCdiQR/vW9KhVa/yR6xiOlW5a/FYdU8QdfOGBOvLc
Pj3fk73k9azjUPUCbs2DWzt9TAZFuyrd3v6BFWVv69Gu/tDQC/e4/pz388zn
NRrv9gm3a8ow5EY5PYgovKYhqFi311XN82IENbPW7gsYeVxJl4q7quF6+uOm
XrVMDe29/mKpbUsLB9HUb9IPR5qGtqbu0l90Ao9DEO2GYLrD2z9uaM5P6N/v
4HXWzg79sW1D62t8Fm4oe2p3OcbKkpSf1vsPoHNgxINo7Oqp6OZas2ABKX+y
gmXDxeNzqT/1T1UwxpfF4/2rOxCVqrPwTBnPL0oSfT01r7T8z00Mf3I3sYdZ
8jHRt5/IKQ67ejrm1fq+cfv5vrRS4z0o/PIjOe93PxRVL/CMQy55dfFL+dve
N1XuXtZKwzuDosxC8KRcRdf5RIe/q6GgHoQVXtMQVqyL66pmerGaWWtVca49
VMnIuxnKuVTcVQ0XGef6rk14xCUUShBt6qq3o4druf4KQbQ7g+mSNprCZII3
Ouy5rmf+zXDpVGw3fyLm9Wqz55YsC/XX1YNLv/pq7ufzAqcPeYm9NUA0iNb/
ldjLnCOiqT0tmWNZtjx+bhtzPO4dFVuElhiuDlW5k/qa0zx8j5Zw/wLLOjzu
OY2md+DZ+8R/6U7sj5g5/7zMb+hUca/EbOdJtMfyooIEf/Csoah6gWccctqj
nRBjv9HA8jO3hIdvScvhOk2FGoZK75UTHf6uhpJ6EFR4TUNEsa6tq5rpxWpm
rVXFufZQJSPvZijoUnFXNVxlcdMaevB+akcLonHszK5BdTQh+zIx/schiHYv
sJwTMxubW05bP+JwNqtljRU/9bHk6cvd8UHuI/Bu3HdI+xFRH6/Y8d/FrVCD
aHOCrvmHfAtcZCKNCU/Plb85L/Ojsng/eajAx1F5PBW6v2GOSZWeM+MU+KBP
Fcd1cBmJofzoW54ajceoA9muZIRUREn1As841KRL9d1b1DBUeq+c6PB3NVTS
A+DWiq2ZXqxm1lpVnGsP3XoMKoajXKpTKY4ZKfCZDDGIxu+mxzbWeK1JMPI/
DkG0O2GoOPehL9Vy74f+brXEQqfFmlHIRj3+a39ntCCaGcLzpcpUXN9M97ym
8zbcd9YAJjcxaTRvrDvEE8M9/T30DcWMDLl0QKQu87ys+JdPXzSFlC/G5zjz
87wDUVS9wLMNNe3h2JekMKRZUDwnTXT4uxoq6QFwa8XWTC9WM2utKs61h249
BpXCYS7VmVRdDu8tcMwOahBtjoBaLd9difE+DkG0G4GlHwhrQDVcz/WHnlib
Aax851LigCaNRvt+0FlFLsFDD6LpyJRgfEwx57H5zLf59jtZroCAMqA2MQms
RuoL9nTQKGVkRPfgVJ3Y0ae2MxXiaBRVL/CMQ05T+ZeUlUKlvY1utwUP9niq
hFsrtmZ6sZpZa1Vxrj106zGoGI5yqU7FeCHYizcSQQ+iqx6e7P+K7XsgiHZP
6J28BHwnYmH6G5cOnThVoldonQ05iKYjUwLe3S7Mr9VOW7ylNsUIrUaSi6U+
nZOK7C+OajX+PThYUcwo4jDzKbGlNSS3WUn1As841DSVf+eFQqi0t1F0+Lsa
sMdTJdxasTXTi9XMWquKc+2hW49BxXCUS3UuWHnaDwmZOZU8DY0aRPO8hyOI
xozlJ49vGj0zrM3brT2Ii6f7fRKwMkH8xmFjwY0TsV/N9R/63qvUg31C/KI3
xJ64XmgUfNT4V/4vG3YuH/Dx/71GXCVM3II9uPOomEnbj6dwBIAVeYnhM6L6
jXiTvA273fsvvzXs1wfm+4j/u3t29wHt69TzDfadsWNHPo/AEuQ0/JM2Z/Lk
QeP6t7fcyt14JRk8UlqaMaIdcdc2p5aw8qJzq0wFfeL3vFbT9Hm/4M6jPo06
clVEG0iQh9JTydBNt+Y65Ip05CC6LG6a5UO07Q4CGvPqEIVzN8UIrYVSCwKK
LJZSOfb8X73phYWak9uspHqBZx3SsPTelKzuLJUahkobJdHh72qopAfArRVb
M71Yzay1qjjXHrr1GFQOB7lU1wY5iBZ/nHi2svh0xMiX+vitPbD9fM7Nm8dP
ftHJm4qGhoddKOcJ/x6Ups2a/R6RXezRdUzwrtRjV27/efWH1F3Bn3SqTRx7
NfSLbUWcIZe+/FLMwgDzg29PD993Iuli3u38tIs/rdu1uGM3Ylmvd+e4k5l6
plUqz97aexgRllrwC76gM9yIDmvg5/vVkbSUMcPJCI7j2Gepcj75O3noB30b
MxVsCh4NxHsiP+HW0sixmf9gxCHDxw/M8n4pePncQ6eTr+Td/G3xQjK5WvNK
4xlHM+09uY6+2thcZLuEP6l/xirK8nJycv66q0CcbgtqEI0VRIdYfocWRDsp
C+JO+oomGq7VyKqbc0fQl3mx8Wy05HyphCJ0t3a+puV6kRmrVCJKnrpLf9Fj
5UXnP1sYNHL85OEzxvXqEbZyyW8lonEmps/OPBg1o9/gwMhp06KGBUVu5V1K
QsRwKXVR4MjogUFdIsKTyAvUDA9ubN4QGRQUGRk8PSpq2ETbkxhFxZCqXqR6
qSOq+c25v24c2m/cqE+6hIUm3aC2Rhhv5x6JigyMjIoKnjGiR88ZWzfeqBBV
NVZ5/fKx+YsDAgIjI8eM+TBw2FKBZlW+Nasx6gsPfL9ioN/IGZGRgf3G70go
MY1mzFAUHxJ09AZd7Qc3Nq0ZNmzRjH49Q5bGXrlvUzRmLNr9VdiqDfl667/w
lBU1rp//1J1EWcaC3EPnMnUCnrv6qWlj+gfM2p+se1p5LqiVbeKNtHY3ybwr
jqrU6vh8zkQ+chgK79RDrJSk4V+NeNPL6u0S2wJFD6KgKJz8YXnRuaXLhgWa
5A8NHTqu38SxiZcLFHJkaOPO3g6PPLr5FIusK2nF2Y9DvRiO1P8Vs8kuUms1
rb35/ci9RU2fiKxSOfbN8caNCYpLxRXyqiq7VFwNr+rCKBlEJ1z9ZYRXk8Xx
zOtlsLS9wfWoH3DtvTWNi+LkQf7mgeHh/xnrWVMXKoydTt5k1G3p9vKnPA9q
64f+55h16z+4e2ZEIO9fMcPlse9RYvkFnzm3tVWnwNRiI34vZ31Luj5Wn2hl
y0ks10ynM4/rrbpwL2N0u5ZLtxTyaMl3bcL9m4fCX+2yM4txr3fVo3OD29N6
9P+J48ZvCTDzpckg2pD729aADzrUpv/R+6WRMZP2/pqtV3BVFDWIZkXHiEE0
/89UhEplEViNJDdBaDiOtZcB6qaqTr4Hf/lpVk//LWlU82EF6ctbaLQh4ZcF
9g3rik9HjG7Ust2q5JPl5NqRUX9zQWjLZbts+zMqf11c2bHrvluVOGbSQzOP
waGZpcXJg9sE70gqMxeB3fr1i9e7erRo9fV1uvUkiYGiXsQXqidqRcFe/w4b
s++bpiGExwkIvnAf0x3Z2qvXsEQ6q8Tw68GxWo3P3LgSgU6sv5cRPf1/X2at
CurTksZ25jqyQI3WpMHu5H0f1KfRsGHH8s0uHDPkxwR1/Dr3z42Le9elr4HA
DDfnd+v2deqjKmrfus+n2yusjMkfp+e9KJKKz11W/JGNPlqBFBqbp4z5Sz7o
tjHxy1dtdm9JaneTnV87ofdWszch9oJ5DP7mvK2BpIYh/145eZVC3QCI0vQy
ert0sUX1IA6awk0YLh5f2LbFrEPnLY7eeOv3Dd3brLt0X27ZNIjjzs4OL2V0
cysWWVdSi1MWdb0Yjtb/lbLJLlJrNa09AXpvcaBPFFKpdPvmBOPGAMml4sp4
VdVdKq6KV3VlFAyiAz4ObDYtttCqSzPDUtsuV1WZFRFILS0RQ8mmAH3xvq7m
L8NWNxkxHvScGFPIuSO2LGd9a/MvtA2mHrtu5RuIQ8upmHTohB7NYs7fIX7A
OPOZ1aNky2mtpXrz1ixrbaslZrm+vYd1bLMm3TpOJq/yMWNvDsnD7YteqY4/
2+1LOzWrbZuliUm37j82jQ5ddvaPYWH/JtYEPN6eHZ31j4P3RLtLEE1tYhJa
jaTS5hU59gp1U5Wm1b/+PbR/8p/MHmbWlZb3njusKHvT696aN9pvvsTudbfP
zHlZ/pERJbFhzeKTzYuNpAD13+378of/PW8ZrKWx4wmB6YvIJYshpl70F6on
6qN9y5sv2/3I8mZNncg1q7qGRLKGFTk0BHbWm1fwPN7smXib0awGXc7quE9e
qhVx5Abztyq1Juvlfv5HCxiS3L20xuu11+pVX0hnSN3RaTo9/yGNW0Do7w9Z
rxKdWPKVtfZl85jnufyO56mLa1q3bGmT+S+l3TEsM7F7WHQ++Th5+CHHYSPU
MOTbKyevUogbABGbXmpvlyW2iB5QQFO4aY6Rt7ND7YE7U9nflSoLl06pv8i+
HYvI486uDi9ldPMpFlVXkotTFhW9GI7c/5WxyRJwP99dDXJvcaxPFFKpTG/u
WOPGeBeSS8WV8KoOcKm4Kl7VpVEwiNa0arnlik0OATN0slkeYZ4RzbcZpCR2
AplfzVx1qTq/L7i+aERpPpmcpHe/k+yMg+ogWsO84wkr2bKMyA/X1huwansJ
3eqy5ZSjJdMbFm6wvfSW+RL+C5WQYNW96Ys9/6/18l/usIzBk/KUvtSuae/x
UVd5vZYUnrEgmv4MamvHqlHw2CvqSkTxTVWaVi3WW39/oXTFPbrv5e3u6s25
0IQXpy1+Wa7wj0sTezffQi5DUWdoW2+RwPIzt4wO/eqsOatHhhjC6kV/oXqi
Vj06N6RxTJr5uFVLA/myJyS4ZWjwDApyGtOw0YJTBaykdioRgt0lVGpNksrS
lIBuGk9rSagPCiarOSGGUJpRlzqo+ecXqVFh+GGTf21bV0vNgrjTkxDK4r4Z
XOwp1qRLUrtXPbowvNmc03fIf3+SuM63FtflesJ75eRVCkcY/jhy00vt7fLE
tn/PIKLCcbw8fnaDFl2SipiiYUXLJ/7bw77r49HHnT0dXtLoxnkUi6wrycUp
i3peDEfu/4rYZEm4ne+2gN5bHOwTBVQq1b45xbhVVwTNpeJKeFUHuFRcHa/q
2igZRHMe0cYMnRjbb80wglz+z0n0gNVo3gu+UGH+J+xJZlhP6jnBk5kZR1TV
Gn+ENbqZgaRVN8Aq/s79m7kZQ66c8rTEc1w28yV2xoysINqkwmmxtjkzjA/f
HkE7Uu3dhY0/c0E0nWIhMOSVvASBDBgFFsZpeXzXJjyy+onAERyY4WpkEHF6
wIhJudZLAVjFN5+9EBp9+4ksgXN/DPWh16ZI4TmXj+wQQ0i9kl6onqiFaQva
0FeWULveao06eNm6Ccsurm3Gc8QfkW01gQgHbPJtsKwTc1o/7zcvpnqNS73W
NL+hZG1UGy5JLAtK5AIjlpX0QVtanyYvGeLL4dYfFuzuqBW4GkC0rKBdabb7
wcSeYg8BSe3ObEpqc421TyEghyF3doq8SjHEExj+6E0vqdayxRbSAxqICicn
tNYXA1XlL414pWGL5ecKZDouKeMOqcNT0352h5c0ukk4FYuoKxnFKYtKXgyX
0v/tt8lScTvfTb8ftbc42CfigiqVZt+cZNyQS7d8s7PbqzrEpeLqeFXXRsEg
2vYWaQKBIBrxjGiyIYgCvPfkmwtgJj9bB+a84lkFO8xAUqTWsuXkEkNcSzaP
275E0SCaez2tek3AhF/g2X/sKI/k2QqisTO7BhFHvXmMOpDNN+TJrBVFFtbE
c19JeXw6JBTYFEbe5cdl8+kUCxvDhRnLftg/qW2HnVdkbirEck/NOZRmYArP
fw+CPDEE1CvphSqK+kfazC2HdGbxqAHFtRkEu7B3aF3uG0KxaydmvmCanTz3
WZr47aHqtSZBcfqKZlwvx+lJBZ1z+DQtKey7k5Rzv5o8uSGX2STPNuS7X1K0
LM61U9Gn2JMuae1+7fSUrVRTUvvO3uj5wx2bMIUchpzZKfIqxRRPYPgjN72k
WssWW0gPaCAqnHIr2gZTEtMVPMFD0riT3eEllUI9wqVY1M4pvThlUcmL4ZJM
n902WSpu57up1yD3Fgf7RFxQpdLsm5OMG2rpjDR+e72qQ1wqro5XdXEUDKK5
AxmBIJpMgBeNhe+mxzZmR16WcFX4QavasUccI5AUy9iRLSeXGJK1hP4SZBhf
mfmXBTIPfEyfdabMRczIp3NTly+L1JQVRPN+wVENKslBaKWaklAJ2cR3RFLy
cNkr6ott9Z6F6tfejBpMbE5pTyVDYhXlBRk5pzbsXdWnXbuoyBP5toc/yhee
/x4EeWIIqFd2vVQSFccFr5Uk244rIYQuDmkVS9XWxApjRnsyXs76Gzmp4NpR
RW5y0YZG3WR3S+pYBm73ilAWx+QK4Sneeaxou7MgD4rkXL0hm5LrT/IqxRKP
f/jLa3qUWssUm18PchBQOCMtzaNzyNvRX8UkpqWV2+usJI07FlI6vJxSRBXL
ryv5lVIIlbwYLrf/y7PJUnFT343eWxzsE3HkG6JF7ZtzjZtMl4rL8aqOd6m4
gl7VxXFmEM0M01B4pdnWqwbrB9GDaL/gCwxDJCGIli2nIlpCfwkyLLXwKZBV
a4/x9p83gnxPNHXsgEhNmUG0EuJJgt4PIrRSTe0H4UtYlQJ1ITX/piqb5B/m
30hT1n7FbutUMSrDUKP17zx7cTDBrEnrt8ceOJnM3s5gH1QiB78e5IkhoF7Z
9VJJVNzSglxZH9QGK4+P9mZYv4FOuUE6wETV1rS8fAxHiiA14bHdUfW4JNHX
k6tq1AYZbveKUBaHq0V4ijsLCEdod9tKcX6goYYhV3aKvEqRiA5/eU2PUmt5
YgvoQQYCCjeD5ZyY2ZjlgYmrLc/a3M+FjqRxZysqYoeXUYqoYgV0JbtSSqGS
F8Pl9n95Nlkqbuq70XuLg30ijqBSEnRv7hTjJs+l4rK8quNdKq6QV9UXHx78
Zjsu3v58t/XJ5E7CVYJowVjYmstHxjZAepBVO3b2hcwgWpKcXGK4QhCNpED2
0oECFzEjB9FPk7583XILMN9JfdReIXLO1PCLS/Zs/pEO7WKEDq4hExh4kvOl
Qb6Kaz2Qwib5x1pUzmkVmSqm9nd84cRd2WIIqFd2vVQS1SIt5x4uMq+GcRJy
NdQ4RTvARNXWpJN/OGZ6/DuqsKzD457jqhrpXvnCIvGyuCYw4k/xq1G03ZmV
Iq8j5PxAQw5DzuwUeZUiER3+8poepdbyxBbQg3SEFE5juJbxTficT1p1qb5E
1rvNzmvCF5DzI2ncMUUV7vBW80kZpYgpVkhXciulGCp5Mdw+DyLVJkvFTX03
em9xsE/EEVRKImrfnGvcZLlUXJ5XdbxLxRXyqsysYxYudBOWM4No8ugA4VCO
E+QHmeJpp8SWMuIdCUG0bDm5xHCJIBplUzkriFbi0E7kIJo1cPiCaObbeO+F
UQss42Co+XB4AcdB7/exe+OMJadLYGsJf/KPwLYjuokVuYGLF8HEXfliCKlX
br1UEhW3tCBX7hO5t4Lznj5qNQnRX6vZmvQJCVwv599RRW0bsdUn6V55hq14
WQIXdwo8xX8OjHi7M8ohcxc5jz+lzILNwZKyK0UiOvzlNT1KreWJLaAH6Qgp
3AZMn3/z3OLPhphjabFsT16kjTsGkjq8jFLEFCukK9mVUgq1vBgus//Ls8lS
cVPfLaG3ONYn4ij20IyofXOucZPnUnFZXtXxLhVXzqu6Ps4Moi3n22skjkHW
g0LhGPMELavlFAlBtGw5LS9wtSCaebw532dcZhDNc9isPj835fyFMt58Djbo
QTSVr2KG72hrxv3jPBtnJIonBcqOCX4BF0rIkQa1dYiVpYM9yZrZa2vOE2ZZ
1bchVGNz5UFhRvTnCffIF5FNLGtdCBnBxF1cvhhC6pVZL7VEtbQgx6yevizD
cnBHVcaPY5PSSAGoIY+4RqRma1KScL2cf0fV099D37A1vDg9fCzdFbt8fMLu
ZEu+onhZlgnMnay4BbtLjWhPWSwJ4ykzCO1uoSxnfWvTlKNJfDb5lbMqf8PY
xDwDs16WvLgniWubrqQMtbxKkX8XHf6ymh6p1vLEFtCDZAQVzgNW8c3yHrXk
3zcqbdxVw9vhyfmklX2WUYqIYgV1JbdSSqGaF8Pl9X+ZNlki7uq7JfQWx/pE
JHtofkjUvjnXuMlyqbg8r+pwl4or6FVdH2cG0cSt62sIZ2fmvc3JApuYsIs/
TO7W5/t8o82D/PtWsMe/DutEvd3m5EMJQbQdcpK4XBCN44aUbQPrki/j/srM
+ohvuyeiSn910bRedcx/fa/n3msI50CiB9HE1Z9z25AZ3XzZIOSyG1F8g9kn
bFJKZIgnAfrKMyEXQ/2G71ZxCVA7gFipgNi14xHt6QVqeoM2R1nW1sk0nZv3
0he0UyaPwhN0f7pzB7L+sWMVgkox4spVsyBHDEH1yquXWqJaFoW4Bhp5zGb1
iZSmGULr4YeoyQPlqtiHObDBSvYtS71TJV82NKjFfw5JqLNHOFYz+C5noc0y
3XZYUcwHzbZWt6NAWbejhzPPY3+8f6XnQmrLnqiEls19zKcIUNrdUifzRZbV
J7o8uLW9iyWrkJrehOzLNP+3aQ7cfNyx2/ZUikB0+OOymh6t1rLEFtKDVAQU
jl09vey1tvVDJ122XdU2K0T25l9p465aVr7biLiNlfRSRBQr2DnlVkop1PNi
uKz+L9cmS8NtfTdyb8Ec7BOR7CGOZN+ca9zkuFRcpld1tEvFFfSqboBzg2jq
Im8S/4DUUh69GSrOfejLSmupLD3qT907xXU5HQF26/S8f1GB9qDNx/Tsd0sK
ouXLacYFg2hKVDM+CzfYjFZqFZTA03PJeetD56l9GTRIh1hKCaLxe3k7O5Af
o2tPS+bYVEwe5UcUPT463/aaAxnioUNfeca1ekwjfKmlJEgn5dM5qYj+F+Ja
xtZB39FXK1I7pzjsFZmQU70G8qQ8ZaDPJsudfeSSL3/KljE9KbRD0Nm7dlgz
wcRd+WIIq1devVQSFRe61JJcPa4+N6Y8N973nZQS+mdkugXv4XWY7vDm7u2H
XSjH5MuGCFkFG3+K3Tgz/yViLHDsa6DayGakU8OHTukxTYr8Gm/IZgwkkbLo
3VtEOk3jqBN/oT1Fuzarp3C0dqcgo6HqZduqUzu9pseVkfqm7lqis1Me3NrR
ibFtTV6lcIThj8tqesRayxBbWA/SEFA47aF69ztpc24NlnVkrLbBgtN3ZBUq
cdxZ4OvwZDRka5+lliKiWMHOKatSWHnRmXVLNp9I09mbTKWmF8Nl9X/ZNtlF
aq2270bvLQ72iSj2EEezb841bjJcKi7XqzrYpeLKeVV3wMlBNLFikr3pdW/y
792il9ywPc9Pfy8jcuT/1H3p07MFGOeD2vqh/zlmbed1xcmD/M3fKj38P4sv
somzpAXRdsiJu2YQzVJgg8kJ55gKNKYfjiRDWE7dWp39pUHb+SspiDaZgYvH
5zY3N6Cv755cpgnGdMm7xpg3TWv7B6T8yXHCvhzx0KE/ggt9ZRa81FIapJ9l
mDJD2t5eI6Jv0Fnu1CYdLn9H9hmLnIaUTT7RrAWTRwe+9KtTa9TBy9a9GTOW
f7/j/Y79k7nUiw5nHqMtksUQU6+MeqklquCllmYrVL0UUB4f6bMtlZHoghXG
jKpVy3Plb/esn8QMRTtX9ekUxCxOxdY06k4O8LG+Z9liQLh3b5FhDnuhAzMU
rpz9ej2txcphWUl+ndmroJxllV7b0aNTpybe1abj7sWVnRgBFI+EG7sJPoXc
7mQZxI0AlumioeLs8I5fXqIXTMnJpKVeaXt8RjH29MmrFC4+/EmkNj1qrWWI
LawHaQgo3DT1eu358LDvMm9YJ4YZKn4Z0fu5WXF2LJxKG3c03B0+P2bCvz04
55MSSxFRrGDnlFGc/q/EXuTo5npEKmp6MVx6/7fDJkvBjX23hN7iUJ+IZg+R
7JtzjZscl4rL9KqOdam4gl7VBTE+yNkcw2D318EjmzKiDb85k7ZvZ/z964RC
zk2f1HtYjzcdGfz17piY9RtyzAqoyjm/Pmbt2oVbp1X/onHUJuKt68/nsOa+
D0rTZs1+z3xetFdgz2W74lMy0/JvF1xJPvfjsvgpLevVe9//698LjLYHuZQV
nBgb0am2qbXq9Z09dt/Px67c/uOPjCun1+9a3LEbEej4tJj73bEyZjs+LD67
2iTC3vV+frRYtcNWL1y7lhAs8epdIe1JlVMRLSG8RDamEbHr3QGtiXjTo+uo
QZ/viI1dvH3N0MlkHbU92688dp57Ffp2WkyT6m7TLXa3zjaaoVRNwq4jQ+dm
lp7j2r1muHRyZSeqHWf9J/5Uzs2bqWmHpy8IaGAWeGL4advFEXTx5IDp82+d
HhVCLjAEbvqunGfDNZUNpUjwTiy0Bnm8SfpZTH/hh8ndWV6JOoWDM/nHfH89
mXpkvJW5+t2B1tl6Bl3W1ND6vv5HC+gXmhzfuTPfDO/Va0nsFTuvmrROMeJH
ohji6pVaL9VExQUvtaw6tWtQXWr1WJ/2fUi/qKtWXySIxcC3aoeGZ/xNLzoZ
K0tSUta92/79VXHWS3lqtiZ29VR081oDNySZDQKmTz+1vGeX5ctnE/tceD5Y
YHlpMS97NLTkihge3Fg5o9eq478umtC8jslpPjUJnDmmbeRx63Q467IunV/b
u0vs6cL735lma+ZEPiI2GdqWPbnllFDkKfR2N1OxbWGTeuYD4U0zyfVT39nG
WmAsj5/Too45/dJ4LzWo1eJzrAQeeZUSHf4UkppeSq1liC2sB0kIKBzL/mlc
5/6HbpYyJwbG27mJIe+2mbfEXtsladzRWHd4/b0ry5cMfIFY/OaeT0osRVix
wp1TcnGMKzwUuJtDVS+GSzV99tlkF6m1qr4bl9JbHOkTUewhsn1zrnGT4VJx
uV7VcS4VV9iruhysr4EI8O2JEHgPvRhi9Y2b9ROuD6nGv/J/2bBj6eCIQe2G
9KhvChSf9wvuPCo6fGNKSoleoJ9i+htXT8SuWxgQ9k7bgA6mgNq7cd8PzA/+
eOjWfZvPnWQ2CA8ozkKCnIpoCeEldmHUFx4+/OXHM8PavG2OpjVefl5DJwev
PfhdodCOMkz347cz23T2+J/n3184n3vrjaCq2fB/mK7U3Ur4btWIacM7mLVt
atwQ34hlUQczc/RC4xNBPEkwzjGzhitv0Or0CXvRFZ+eNr7n8EGTJgZGxm+0
mu1U7Frh1cR79Xnr/AczWFnijvFv+U1ZFPHx3Plpd7jWHEwdIGFvdJ9e46KG
hoZGDgsMWro17myh/T6Y2JmeMfKdWu++k1KEoAUpYiCpV1K9VBMVx5/mzh7c
uHevvTe5LtypqsyPXzr4rX4zFk0L+fwL7sm5/p8rGzdHvuMfOTs4ONhc3Nfb
fr/DM49XrzWJi4Qyd40I6Tk2KHJc4LClS34rMRTFjNIKnp5nuJaxe+SYzn6m
Hjh58vDQr1IziWFrmnQtmT2gu9+UyH7j9yRzekybssxdl1DXiqGdfSNmBASs
2VZkYzMkPyWp3XGz5Asn9BweGD09eNbBVGvJDborKxeYWnP8+KD539v8VW6l
hId/NehNL7HWksUW04MEBBVuCpmPzIoKJpk8a9aHJvGik3PyBF0DMpLGnUVe
S4efGxkUFByfeuPnD4n5JO89DpJKEVascOeUWtyDgsNB7zdq6zVuSOs5pxBu
ehVFVS+GSzJ9dttkdNzUd5Og9xZH+kRReyjFvjnTuMlyqbhcr+ogl4or7VUB
AKhxkLs8qo+XBBQF1OsaUMeo8l9wDAA1HDL7lDc50+XBnmRGvLWPM8gDAEBZ
wKUCAABUFu/votV4yT5OBxAE1Osi3Elf0cSZN88CgIuDpe0Nrsd79qkbcPf3
BYMVuC4ZAABxwKUCAACYTzX0nAhzD3UA9boG5Pmx1VdMAkBNBbuTd2RW2Dzr
XMSqm1GDPTy4LmF0E8o2Dpl/we5TxQAAQABcKgAANRFiN8qMnsPDThQSG0Ye
7lrWrpYbT5xcDlCvS1IaO16r4MZ/AHBXqJugrc+QKU5f0UzjM9eec8KdCZZ/
dvhYdxUeANwOcKkAANRAzOdJmqZQtaYmmyK7J5lhvrVGRVnduQDIBtTrilQ9
PNn/Fdi9BQDEraxveWq8X5qwN7X6bFGDLmN0QIPRkQoca+kUdMU/hg0+mG/X
FYcAAKACLhUAgBpJ1alvBjagjgE3ph8a16LDnutcx04CsgD1uhyVusLvvjHf
1V5n9g+5lbBsDtRosKLlfbt+c85yKrhiN205C/299OnvzD8NB4oBgEMAlwoA
QI0FMxbtigsOnjwtJCrgk7CkG3dh7qEkoF7XITc5Ust1z1to1E2eS+oA4NnH
oMtZvTAoaGho6JgxHwYGzhG9hNGVwW5/1mdqSrYB7CwAqA24VAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAABwNhqNk/8HAAAAAAAAAAAAANwF54axEEQDAAAAAAAA
AAAAbgQE0QAAAAAAAAAAADUFoz7/P4uSbxudLYcb43pBNFa0Z/Vv9zDHC2ML
VlGWl/PnzZOHkm/ddQmBnIS6eqisKLp6Oz/twoGsPENN1jJQ8wALA7gRNa27
unt93V1+AABURFd0YmSvGUnndU+dLYk743pBNI6l7+82Oia/0uHSMChePqG1
h8ZCpzUJj2ukE1JVD4+///LN2tUv95wWWwLrYUDNACwM4EbUtO7q7vV1d/kB
QBzdrZ2vaTVNn/f7oB2DD/o29tJ08j1aYvVr4+Xw/9OaBoO2nu9g8pfvvfdq
72a1X4zPMThFfOeCFWVv7d1mVnK29aerhwUHB7STzKiorEfOqYjTccEgGsee
ZI5sNjIp29lWH6vMODqjkWnU1Z79819OlsWZqKoHTH8jY7034ej77jhZpfTb
AcCFAQsDuA+YUZd2uAZ1V3evr7vLDwAoGCvLfv5hbnMtuV6kDfD/NiNbxxkW
GytLvvlyQF3iZ15BfmsP7r6cn1dREwNoIoLe2Nnzo92per4oy2Q9Tnw71qxU
bXDoL38/tv5Bpe6vzCs/L4375EXzj8bHFNfUT2CuGESbGjDtv2+1Dr5w37HS
2JL388znNRrv9gm3nR3QOxdV9fDg1k4f00DVrkp/oPzLAcCVERxZJk+3rUe7
+kNDL9xzvGQAYMPt0/M9NZpW3nvya4ZDdPf6urv8gLvhLJ9VEjvB0xxEvxKz
/SF/Z8eyjozV1h8Rv6vIqZmuTkZXnDyoidea/RWCWdxYxsHQ+oRKg3alCZgP
/eGNA+pyqL3mzF5Qg2j9PznbtiwYERo9Z37ooKC+o0O3n83UC344fHRgzavL
dj96/M+Vjdtmdn+/Q22PzmGhZ/9mKVqjOTe3c9A5WyUTgVXtaclONv2P96/u
4KHRBE/KVXTEYVdPx7xa3zduv85NvryqpAeK3ORIrUbTxS/lbxVeDvDjLv3Q
XeSUgfDIqty9rJUGFvFqNC7V+Z/+uKlXLdOkKvzyM5G5J6pbd6+vu8sPWHAp
OyCA03zWH6fnvWiOott3SSriKdoUPAa2DNpxrEZvATY8yJoQXCd00lWxb1b3
N8xpqkH4vKUv2NNB03tTspVSa87sBSWINuT+uq6//9qTlqgZ0/92YnGrWn5L
43nXc/TF+7v/a/mBY8t8vKt35lilFelMpTed+MN1LhVXXQ7vVWtGXJkzezuW
FxWkwn6iqtxJfUVXzFwJlfRAQcYR2gkxRTUyr8Z5uEs/dBc5ZSAysrD8zC3h
4VvScuDAvZqKS3V+qru6hjD2I6pbd6+vu8sPWHApOyCE03xW1aMLIb7mKMPj
o70ZHIWbgseJHXpsq9kRNI6V71zapWGbndf0Yj98/OuwTubzFGx3l7MxVvzU
p3bYwRzrF9SY2YtoEI1dPTmle//kP62jZcMPm/xr1wrZc44z9Hm0b/UbdZu3
ek6radooJGbi9qMHfvrm6MoO9UdYVG3QZU01lR7Hd5bU/Q2za3ftd7JcUm0U
xVB+9C1P5fcTVRbv76LVaGpNTb6t5GvVQyU9UFDeATZEOxp36YfuIqcM1B1Z
gPvjUp2f6q4eow44/bgSJRDVrbvX193lByy4lB1wVQwp2waa9ztrPgi//JD9
N8xwI3pIy0+3ldbUfbsk2I0z81/yCNqRKh7YkrssTXwclWezH5pF1cOT/bWr
MoR/9CwjEkTfy/vav9vu61yrFvdy1rfUaHr3O1lm8yd98b6uhPV+e2bUmcL7
lubCMhN7zIgrM2L6rN++7uPv8aapdN7I6WnSlz51W/7npvNCK3I/keLZCOQu
yFecWjVJqKQHEsrR1136i075lwMCuEs/dBc5ZaDqyAKeAVyq8xf/8umLGo3n
s3KYrahu3b2+7i4/YMGl7IDLQsUdGo32uc/SGJ/fMEPRuplt5sTV6H3QJgwV
5z701QSgHTZF7rLUaN5Yd0jk0/3jv/Z3r9E9UyiIxgw3Zvr0/TbdaJri5aUu
Sc1jTfVMquvMnTD/aN/qrrW5Nu9jhpLEPQtHhK74Mn7Cv2p9kiBYeuaBj+vV
W5XutPUNlfYTqbu/WAXU3VdFOnrRjBFAadylH7qLnDKAHYuAMC7V+atO7OhT
W6PxdWp6mHKI6tbd6+vu8gMWXMoOuDJlcdObmj+fNp0dV0Z9dMZ0Ses6DI/M
+qemr1QbUra/X6/B1GOc+2etebh90Su2O3A5uZfzZbsaPYEXCGOxa8dHdQ+/
TH4hrMhdMZq9Q5kMojWakVbJ8E/KU/o+120J/3ZpzJAfE9FgKPFmsSDaY/yR
G4gVURqV9hNR2cvuc2+juvuqKEcvmjECKIy79EN3kVMGsGMREMalOj9WFDNK
q9Fop8SWPgubCkV16+71dXf5AQsuZQdcm8K0mMbmKNqnQ0IB8W3UcGrPu68F
nb1b4xVHfqa3TXTnpupyeG/zWeccn5h1h+bPTy+t/u/7udtCoq/W4OUd/jC2
6mbUq4EJl6nO9yAvLoIdRN9Nj23MEUQbUra2ei8sk3/ZB8s8PLZRg9knbguW
TgbRNhG6wyA2yzdVfhPKk7uJPbTutAtSJT3QlMVN89RwnOwHqIu79EN3kVMG
Ko8swO1xqc5Pdddn5fAKUd26e33dXX7AgkvZARcHM1we+x55ivF7m5Mf5v00
metApxrIk8R1vrVqjTp4GWk1gdqDr9EEhP5uFXRXPTw54IUvLj1RQ0g3hTeM
rbi2sWP1WfFY1nfDv2UdeYed2TWojkajbcjS55PylIBmMefv8LZUZelR/zYe
IyblPhQsnf5G6bQg+k76iiZim1CM+sID368Y6DdyRtS4fv5TdyaUPMaNBbmH
zmWyDgDU3dr5mlbDB28yJ6bPzjwYNaPf4MDIadOihgVFbt2Rz/5kZbiUuihw
ZPTAoC4R4UnXzWtthgc3Nm+IDAqKjAyeHhU1bKLN4XiIMkvSAyLVRU8b0z9g
1v5k3dPKc0GtNJo6C8/Y7quXoAdWEQl7Fw7sGzQ2KDIkaP73qaZKGQuuHs7I
4bmODenlhtxfNw7tN27UJ13CQpNuUGuaxtu5R6IiAyOjooJnjOjRc8bWjTcq
RO2TOm2KozWrav2w+qflReeWLhsWaBI1NHTouH4TxyZeLjBKXQOWK2fl9cvH
5i8OCAiMjJwRFeA3eNmS84wDGexC6qhBgW9kYcaiXXHDhi2a0a9nyOr4fJvK
OrI3SkV6B0CWAW1o8yjn6rEFMcMiZ80aGhnWvceEDdXKMQl8/rOFQSPHTx4+
Y1yvHmErl/xWIjrjUtNoyOz8fJIaSvZvDAtesKB/UJeZ820TGrHiq/smhm3L
LKz+w/3bhz7s37h3r7032QehkN2VOLxCL0tpOJL1U6xvcyFJt/bWV/nBRb6W
YeXGjPkwcNhSHmHsll+GOZU4/B3sfBFB1rAr2gHVJhgiOhPxWdU/VGSGICxL
2t7gemYt9fbv377jpkulNf4jNJke7KPxCzz7D9rvyT34Gk3TeRvuW82cC88v
9OK/jha5JxAgTtdN/XPTGuqdS2Ov2BohU6G7vwpbtSGf7bJkdXU5dpsvjMUu
7PEeGl1AnkiBGa7OHrj3NrNi2O3o4cQgtzpYzKC7fkZgYomVb1nUqTb1GVqg
dBPGhDVeGqelc1NpxvyTFuxO3vdBfRoNG3Ys39yoRI56UMf4Ixt9tJqmTbfm
ch8CiLq3RVd8OmJ0o5btViWfLCebwKi/uSC05bJd5Rbd/nVxZceu+25V4tjD
k/2beQwOzSwtTh7cJnhHUpn5EezWr1+83tWjRauvr9ObQ6TLLKoHRGyKNuYv
+aDbxsQvXxXcEI2iB0sRRTnfvN29waixv9wxK9d8o8HgTYmrW2s1Pp2TiuS+
vKJgr3+Hjdn3Td6VCPmJYxkw3ZGtvXoNS7xaSNp/w68Hx5oKmct71DxqcdLb
lEu34s2qZD+kMVw8vrBti1mHzluGv/HW7xu6t1l3CeUYC25Q5dTfy4ie0aOx
99KjqbSclfkrZzVq1H6z3T5U3kgXhXtkYYbCtRN6bzVfw0EcF+Ax+JvzLCfm
yN4oEckdAFkG1KGNoBzs2omZL2i8o2KLDCaBf5rV039LWjbpsrGC9OUtNNoQ
egeTPTIr0Ux2b4TESjdN6bXxR6I5zFd5+ny6vYLVmapuRg3WshOBqH36Nl8w
qe7ayffgL9KVhqPpTam+jQDqhmh59VVhcBEQVm76/77cOa76slFcn5Y0tjNH
tqpd8ssyp9KGv4OdLyLoGnZBO6DaBEMEUZ9Fo8YMgYPHJYm+5uPF4Fx6Giz9
QFgDje/ahEdo6nia9OXrHoQGQ/Zlsp/AStZOfS6C5zpa5J6Ao/t0zHBzfrdu
X6c+quLzYvQV4VaTfBldXa7d5gtjjQkrn1+ZQL7dkPbt4M3H9ExtFqevaEb0
0kFW/y5MafZ6bw/LZ2iB0onfxo7Xapx1sBi1n4hvuyJWlL3pdW+Nn//RAoZd
u3tp7cvmsduFb6EGaW8L9fI3bBzW7TNzXq6ON0tiw5rFJ5tXUYwXgr002vrv
9n35w/+et/RuswI1Gq82e25VyZVZRA+I8BR9cU3rli1r8XoHRD0wfvxvj6Bh
F8oZv6V6qUbzXvCFCpkvf7RvefNlux9Z9KypE7lmVdcQ9jkV5PkA/Mcsq9Sm
uMxmVbIfUtzL29mh9sCd7KsTjJWFS6fUXyS786DtBdMVJw/y93jdRk5yExDi
WZQ8yB3pCC/mGllYZmL3sOh8sijy7O7xMcWM6Ywje6M0JHYAdBnQhzaScsjr
AJo23fzTCZurG8lBx3FUplSZlWgmezdCYpd/GNyDdrUV1zd72eTmUTl77DRR
XfH3bxNXm3itSWD0O6q7alr9699DpSkNR9abIn0bDdQN0TLqq8rgwmkr92bP
xNsMYQy6nNVxn7xUK8L6W4Md7SXPnEoZ/g52vqgga9gF7YB6EwxRRH0WhSoz
BG4qti1qY44BPafFKrC04vYQi6UeDV/44iLSdmjLaS3sg/0xff6tX5evGqLl
3X2J2hOk+HRD6o5O0+n1JU4vxrPKJDM+kmW3eb9Ep+15bXpcmaGy9MfvQgfN
vMq0uMSp3cNNGtJaKUEYzJg/f5Snpva05HzLMwI7somN7XZ86LEL4e2KlaUp
Ad00no0WnCpgJwKQyckaz5nszePVD3JNWqy4l7e7q7dGy3WGXnHa4pfpxZbH
pYm9m28hlWNenzFBfl6pFic/c8vo0K/OmtMV5MmsyLZNsaK5vQOiHkgqCvb5
ems8PVf+do/1S+ICu1c4klLQX1716NyQxjHkdQn0LjONL9vP4pZD9njWfFRq
U1xusyrYD2nK42c3aFG9+4MUomj5xH978A8HUVDkrCz9Ocjfw4PzzEnSF9jR
e2WPdFE4R1bVowvDm805fYf8L/MmJnbXdWRvlIi0DoAuA/rQZiqHujiPSznU
BkOP1q972XwBISe6PHuIHGw0UDq/AMTewObjj1GulvouabVcSebs2czeyY7H
+gZhqUWrFuslKQ1H1psiSkNEVLey66vO4KLiu4bWhohqVtuKyJZfrjmVMPwd
PI4QQdewC9oB9SYYooj6LBpVZgicGHQZowOpVHgpqwHPLGTs+X7o77zLnGws
3pMbnt2XyD1Bgk836lIHNf+cjv0NP2zyt/Vi9CpTz/WHnlg6l9Subp/d5g1j
iTzz+Akjwr9IOnSHNbgx3XfrBtTVaPsHpEjZsE/m0VmtZPKWTrajs24+Iq/A
5t4IjJWsjWpjGvgTYwqtUhroPhC0K43bAvFMWhjvNlyNDCJO1GR8rLf8reKb
z14Ijb5NbkDP/THUhx4U5Gtbtdxyhes6b3tkFtIDIqJFc3kHdD3glsUZriIo
z8XO6pH08sK0BW3oK0KoXWZchzOUXVzbTMO95qNWm+Lym1XBfkhC6tn6LpWq
/KURrzRssfxcAaJDliFnfsyEf3NqwExxzEiN/DwKO0a6KJwji9nZTBOwwe1N
nW38EYZVd2RvlISkDoAug6ShjaicB7d2+pgns7a5bQIH+DjYaOAInV+Y4vTP
fOg0CfqwHasM7Ye7lv6vB9fNCEQmHnumRHZXqUrDpehNEaUhIqpbefVVaXDx
Wzks68Sc1s/7zYu5ajU9liu/THOKPvwdP45QQNewC9oBFScYCIj6LBKVZgi2
GHRZU99r88W5M6Oo48VYsRUixL3Ss1tTKQTWPNr9Wduo6Iy/GUbToLvy2ezW
C1nL3WdHtJ2051A5M2orzt07oPXsE44+HY5cCJKgB/IjsvU3Akz/x7VDA/09
OvAEZYg9QYpPx7KSPmhL91hTkB7iy9GgDwt2d9Rah/aSurrddlvofGyO4ozl
B7Z93FDj/fGwnwul7NSi5LROkuctnTQsTrpBlTozzfZgOtyScsDVPUjPxUqB
YCG6t4XcucDxcsxY9sP+SW077LxCLUBguafmHEozMF8rcEuUXJmF9ICIaNFc
3gFdD7hlcYZzVkB6LrZ7kvRy/I+0mVsO6cxdllqU5spnwy7sHVqX+0ZOtdoU
l9+sCvZD+o3klfENpiSm8xzgJgdxOcmm1zZYQK9/sqGWKPlyikSwY6SLwjmy
sGunp2ylOhu1zeeNnj8wz2h0YG+UhpQOIGFESBratsrhPEclNzlSW30BCgvy
znquNUMHGw3c7g3RrL5E9mTrWTp1iQlHbt7d9GUtWGaZ6q4SlYZL0psSSkNE
3LDIqq9Kg4u2cs99loZaZ5nyyzanyMPf8eMIBXQNu6AdUHGCgYC4z6KqocoM
wUYaU/Ab1WEhcbsurRYeL8D/isrr2T+MiehUm+crKo7f3zDHFOlp3+u57VxG
hQHTZ/32dR9/j2YvfXqWsRRAx4Nvz4w6nV9qfFpZuP/bac08PAY4/rIt8vQq
4cN7WdDZFxzfCIwJq+p9xN1nEHuCJJ/+NC0p7LuTVMh8NXlyQ661JtKhs7+3
Surq9tttCUG04cGN2IW969Yf8dV2qedMUqqzseq8yeQZB0Pr83ZjtSHvXeIq
HSuMGU0s0rS3yksx/430XLzGXHRvC3XMi+XlWEV5QUbOqQ17V/Vp1y4q8kQ+
59mY1Gv5b4mSLzO/HhBBKJrDO0jSA10E1+5UyhqwNkTLUzKOC97qSyqKawOO
Sm2K29GsKvRD7ElmWE+zx/LoHPJ29FcxiWlp5TLjS+ly8nlJOoNO1k2p9ox0
cURHVlnc9KZCP3Bkb0RAQgdAl0Hq0K6WRkA5D7cvInIIuFwqdaYWR9qbg40G
ruzNsNQXZytLS32R55pcXU7q14H1Y1JUiUrD5epNttIQEdetrPqqNLjErJzi
8sswp6jD3/HjCAV0DbugHVBvgiEZIZ+lygzBuoyK/y5vFRZF5Qw8KTv6tjl/
nr2BVODx27ET27Vr92Zo4OpZU7vwpSLTQTSLpo3Cdx9jHadsyd5noO3dZXuW
w48Kl5zTSx+nwPWN4P6GGY1Wirsk/p4g26fjJbETiB3EoVE32TZNwKGTbxXr
6grYbcQg2vhH9rcD3n1+QMC3WdJPpKc/l9saCr7SyY5qczScQ6ByNblO9qNv
T9OO4fi+LzIxpjYa8O9tsbzcv/PsxcEEsyat3x574GRy7t/89zcIzIXslFlA
D4ggFN1q+e5KjOcpFD1QuRwa7QTbAwMpa8CqnTwl45bm49oRRq86frQ3g7fD
KNumuB3Nqk4/xHJOzGxs5TI6x6FvrbJFVE5yp49Atjad0/jGukOSpwr2jHRR
REcWeb6owJcRR/ZGNFA7ALoMUoe2BQHlCHx+pb1t+xU2WXwONho4QudHh8qs
s7kvmGsBn+Th9vmezJkSvXmB68ZhfqXhcvUmW2mIiOpWXn1VGlyiVk4p+e0z
p0jD3/HjCAV0DbugHVBvgiEVMZ+l/AyB/Xrd4U0dB4/NYkQ81OIhZ+awIGQ0
xx9Ez9L69Rni9XZrD422S4tRn04/Qh+0Xo2xIuVd7TvDPu7b2ItYNxjcY+a2
DTllzjgkmcw8QU85qN68b/uNwOQ9X5oumo4u0BNk+3TqxHXbYSLg0M2gx0d2
2G3xIFpffmnZp32beC9MSCqR1wsK02KI4cNhCrhLxx7/OqyT004VI50FZ+n0
7Wkc7kl0YkxuNOD6sEVB9napGy3550L2yiygB0TEi+ZyK5L0QFafswjODdHy
lIzTzce5NYmsJucRFiq1KW5Hs6rUD00O/1rGN+FzPmnVpfp6S+82O6/J3XIl
KuflI2PNSTh854ZR34vlRSL2jHRRxEYWddOlwJcRR/ZGZJA6ALoMUoe2BVI5
nBogXSrn0cTkXJrT9TvYaOAInR8d0vnadDbeBXzim1HjKOZMieyuUpWGy9Wb
bKVJer+AbuXVV6XBJWblOJAnv93mVHz4O34coYCuYRe0A+pNMCQi7rMUnyEw
35z547jXbc5oslyiIXHrt1gQPeXlrbbLU2xMQXS/l50Tv7Ahh62E7wjkRlru
Q1Mx3cXjN3UiHU2oJ8j16VjW4XHPcQ0TyqHzf24Q7epK2G3hINpw+VxctyYB
sWuvlMtfRSE/xFvfKC1QOukF0E+TUxQyk5wzqYDeLFB36S82lyyKTYypNCqB
FaHMAx/X43k5P2LJDPJlFtADIuJFc+6kk6IH+lZTrh9zbYiWp+Tqgri2JpFZ
E9yrneq0KW5Hs6rUDxlg+vyb5xZ/NsRsLWXno4rKSV1lyDvi6IvspW2JorBn
pIsiNrKo/CKBk0Ac2RulI9gBkGWQPLStHuTcRUi6VIFcMs4bfBxsNFAGKboM
5DCxPl2EfwG/4trGziz9UNGTVKXhMvUmW2nS3i+wRU5efdUZXGJWjgN58itn
TvmHv8PHEdLL0TXsgnZAtQmGRMR9FgNlZgjVr8s7P/81zo2rdKYu5wl7/DxL
QbS5rT3GW1+Bxwu9VsaZx4KCUE+Q7dOpFHrbHsvv0EnEu7oSdps/iMZ0R/4z
omWbZT9nc2dcYIY7v10Q39egu7XzNaIjc2bLcJYu+TQ5RSHbyzKCniSubUrf
l21MWEMk/ni1S/jT+imq71kmxney4hbsLmUcZ0VuimFNWrAnWTN7bc2hs0XJ
1uR6OT9iyQx2yCygB0TEi7ZM7ZhFS9GDQBHcOyzkKBm3NB+HwafvKrIcSlCV
8ePYpLSn8osTb1NcfrOq1A9twSq+Wd6jltxDvRDkpDTAZz8ps+MRtCNVRsKY
HSNdHJGRVZazvrXpz03is8nF86r8DWMT85h21pG9UTY8HQBZBslDmy6XVzmW
M2E4cslsrskozIj+POHeU2kyo0oi3EwogxRZhoLoEI3trhnqVh2OJLeqE1ua
T2TtuiI3L0hWGi5Pb7KVJu39ArqVWV91BpeIleNCnvxKm1Ou4e/ocYSEBA27
oB1QbYIhDXGfZYudMwT6LUXZG7u1Wv6L7Vlm5r+SXzB5PuHx8QwF0Wb7r234
xSVUx0EdpyBwj7zI80I9Qa5Pf/p76Buccb2VQ8cuH5+wO5mxWoLQ1ZWw2zxB
NKY7vPWDZjYXTzO5e3FFZ/GvPNTdXjxZQFylm029J/rN4MpCtRe9HdskTPNx
x6g8H2ohxS/4gnX/otZpLePu8f6VngsZiwbU3hbWpAW7djyiPWNN+G56bGOR
1tSdO5D1D6NBBLITLfWRKbOQHhARKJo8XsCyrsIqWooe0GtHIUPJuGVHBlcf
Js8MrD6H0OT4Wg8/RJ/yp06b4rKbVel+iF09vey1tvVDJ122XcYzv0fm9VII
clLBLIcGCB7tW2Ny0NqQcA7BEJA/0hHeLTyyyAsWqw/QeHBrexd2Op8je6MY
kjsAsgyShzaJgHLIXUKca+zWrh9/uH3eS1/QsYaDjQbKIEWFuhTY+nQRskat
vPdYnbiDPckc2XzOKcbhzPSV6JKVhsvSm2ylISKqW9n1VWFw4WJWjvxJyb5l
qXdoYeXKL8+cShv+Dh5HaCBrGHNFO6DaBEMSAj5LrRkCia7o+z6t5qTwfObD
iYuGTw4w32jIecsGD+JB9PqUjLi14b39psxdEOHbYcTymN/usJMMzEH0V6cv
fT8+wndEYOQnkz/o3FP+flj5mO0/eoRIWw9Jq3ZMhGcvMn0636181g4dK4r5
oBlzfQOlqythtzmDaGP64YmNm8Re4F7eIStQsnZCs1ViORKWQ/l4GoWjdNLU
fxB+2SkxNHUUP7108+DWjk6MPHxyA4tNH8BunJn/kqY6n992WxnZUj6MO7uJ
w9ZaB33HuDSQXJbkTysypieFdmCfkC+WzCBfZmE9ICJStGbkwRzctmhJehAr
wnqngwwl40J3NZJLYdXntJTnxvu+k1JC/0ylNhWvOE+zKtwP6UtPuJZ5sawj
Y3lvSxEDRU5yxxPnRU6FF9d4aTVvtN8h78Im3I6RLorIyCLXTqsP0Kg6tdNr
elwZsykc2RtFkN4B0GWQOrRJBK5VpTaEcrhUctZUfYjck/KUgT6bLNvoHGw0
UDo/KlQDUZbW8j7yUg+bmYNpij6uI3sXlWyl4bL0JltpiIjq1sGdRBRy8wjv
RQCY7vDm7u2HXSinXytbfjnmVOLwd/A4QgRdwy5oB9SbYEhAwGepNkMwoStO
DmwZtIN9LLYN5PqPhueMUE5EDxZr0KXLurQbVOROXDI+rn5b9uggDhZr4DMh
4hdLcF1RsM+3fv2xUdZXujN5cDdzS2zsoeRSpWJtsnsILRCxoQ/Z48pjQUFs
9iLPp1NBdL1V6Wy9UIeG0ZnYhvKjfo03ZDPkRunqSthtjjCWaO4GAwTydojb
orcGv8R1C6EV9NZ+vgsIbEs393muK+kdA6lSenaBpe3xGcXYrkKua7HtIVZ6
bUePTp2aeFe38t2LKzuxjQbZORmdx5C2t9eI6BvsW7AfHfjSrw5X3U0K/37H
+x37J7NPTiAT/kU6vDyZhfWACGfRRPqNiLok6IE8e9bKQxEd2Nvc7ThO6Zeq
ZFzwrsbimJHMJbLy+EifbayBo0qb4nKbVeF+aLKZrz0fHvZd5g1rW2Go+GVE
7+dmxcm8dgRJTux29EceDT1X/naP9azJtw7y93hdMItGFNkjXfzNwiPLvHRs
MemGirPDO355iTV3dWRvFENOB0CVQfrQxgWVQ21F53KpZJqZ5eOdIWWTT/QG
5rEqDjUaaIMUEXIOyUolrarMGh/0SkMvax0adBnhHaJSC5h1pJTGFWKIKg2X
rjd7+jYSYrq1p75KDy7q4cKYUbVq2Vg54i+Gop2r+nQKYr7WDvllmFPJw9/B
zhcNCRp2QTug1gRDAgI+S60ZAlac++27/h5DEL61kV/lCJeBmt0qHEQbslN3
5rDHQvm1zW09PAaHZlpSkTFDYdLObPblSIaUbQPrery7Pon7y2Nl6VF/8qO5
EpcykJAr9tYHYvBCWQ/5G6LFZi+yfDq9FMNWi0nDK2e/Xk9bPZXKSvLrPCmX
0cKIXd1+u20bxpbHz27Qwnv1keSfdn2/eUlMTMyS/x7bn5SUYCb1520HvxgY
2rFO/ZH7zouOQnojOe/RZ9alPylP6euj6en/k8OvU7NQHj+nRR1zypPxXmpQ
q8XnWJ/jsaunopvXGrghybz8hekvnV/bu0vs6cL735kawpx4QyxMDW1rZczN
l3x5vEm6Nkx/4YfJ3bmaxqDLmhpa39f/aAH9J1M7njvzzfBevZbEXrG6r0wg
O5GNPJmF9YCIddHpp5b3RFCXFD3Y1u7zXh0WzptC3G7AubwsSckEQnc1Vp3a
NagutRSmT/s+pJ/NSqM6bcpZcfFmVbofYtk/jevc/9DNUuYVD8bbuYkh77aZ
t4RLmWggyklM8N6qHRqe8Te5REkoYetb7T3HhJ+4LbtsWgR5Ix0B4ZFVsW1h
k3rmPFvTFG791He2Wa20O7A3IiCnA6D3LqlDW/BSSP4N0Tj+x+l5L1I5z8Zb
mavfHVidHytRZitJ5DQTYudHpLL05yB/j85d/nvdLKWpU62L6hCzrTD7YPjz
mm4L44rIFxse3Fg5xaaz0QcfcZzUiqA0XKre7OvbKIjp1q76Kj24KKytnKn4
ypKUlHXvtn9/VdwN9jUsdskv3ZxKHv4Odr6IoGvYBe2AahMMdAR8lsIzhErd
X2kZh+es+OgF84Fhvj33XSsVuHIXu3/30pdffNRQQ+I9blJafqFerObCQTTX
A+bYUNtg9gnBDY/kRQl80Q11SrzgWdNSIYNopF3nmD4/78TwQPIctvfX77mr
l2OvxGYvMny6+am8tJiXPRqOj86v9lYzeq06/uuiCc3rmGL2p6ZRkDmmbeRx
hv7Ru7rddts6jC2/trFDy8/T6WY26gv3fDO1pZeGibbegNgNReIpB9TBCALf
yq1KN5+OLvMsIMUw6K6sXDD4rX7jxwfN/z7VNlfEcC1z14iQnmODIscFDlu6
5LcS8rtJZX78iqGdfSNmBASs2cahHF3x6Wnjew4fNGliYGT8xht8V5CZFJ6w
N7pPr3FRQ0NDI4cFBi3dGne2kKshq/QZI9+p9e47KUXiQ12OzGJ6QESmutD1
YL46Yfeowf3GDYuKHB+0dMn5wkeF5ivnuOcSEl+O409zZw9u3LvX3ptctyQQ
FVlq0tKMRdNCPv+Cu1nVaVNcnm6V7ocmh3hkVlQwyeRZsz40SRKdnJMn6qpE
QJRT/8+VjZvC+wdGR08cP2Rwv+mT9v6abW/RNDK7rvh7BUeWyaQvnNBzeGD0
9OBZB23HnQN7IxpyOgCyDBKHtpByKnat8Grivfp8AVdNsbLEHePf8puyKOLj
ufPT7nBFrI40GoidHxFijGyJ6t0lKCIoOnJQ8IbdZOBM6HbkyLe7+42eERwc
FvpVaqZtk9mrNFyS3uzu2ygI6taxnQQZogU3R77jHznbNMbMr/162+93OFRg
r/zSzank4e9g54sIsoZd0Q6oNsFARdBnKTVDKIubWuvVxn2HtDMz6P2Xyft9
600+lsf5e/MnPI/OA17r0qUdTe/ebQM61Nb4fLq9gr90yUG07ZF9nJCpBXwf
xCvv/jwisFFbr1n7kmVPtq1BCaKprffcaANDMyUtTInMXsw/kTpdtzw1ckxn
P5P5mjx5OO2tTMUtmT2gu9+UyH7j97D1Jqmr22e3rcPYMzvbTomzOmwWKy86
/9naid6dPTzq+Y7st+54GlorY+U7l/WuW2/Aqu0lPB+tWaVXPboQ4qvxD0h1
3mdo4FmAvi9epftwAQBwDjC0AQAAANXgD6Kxki3L3m3YaGyCVRYuFURTj1SW
pgb3r9+9674b7JUTasexctna4pjzq+07/1x13N+nC98T7cjSDSnb369XP+Iw
x13bACAB8so53h0WAAC4JzC0AQAAANXgDaLJtG3bI56o85M9Bn9znniCTNu2
PQ+cPCGqVauvrzsspjVH91z78V0I9/fprhJE6/9K7FW//pSYfFdubsAdoC+t
EL9/DQAANwKGNgAAAKAeAunc5fHTm06KSi9lRykPC3Z31Gp8ex0lM4eflKf0
bxqxK8nqkG3zZlWNz1y5p63K4uH2hXV6BJ6Ve0uJA3gGfLqLBNHEaWY+Xfbf
ghAasA/MeHNmiFbj7J31AAAoCwxtAAAAQE3Iy465bxTSFR8b8U7cWcZBAfry
SzPHPfdGl+1Z1dtQDReTxw6IOMPYVGv84/L27s95TYySelO8nWBZh8MbtfzP
TUW3wCvIM+HTXSGINqYfnvRio1nH+O9MBwA2WFH29rd863fvdjCfZekMacSp
s56hY7PsPs0FAADHA0MbAAAAcCQPE758hz55jMTLz6tPn3btZsWyLpgmDqHa
/1mfLkGRUVH9hncYHrBi17accusDRs0HSa0Y2d03Ys6CCN8Ow2eO2XTiZLnj
E5b1xfu61pmaLHhsuPo82z7d+UE0cU3Yc0O2/qjYkXRADYC8A07zRseEP+hR
aTJuu7aN+lf9vtHR1XdVAADgVsDQBgAAAAD7KY+f1XBmXJlTzxZ7tn26s4Po
e2eHNmmyOL4I8rgBSeiKzy2aN3je9I3zPw0j7k6YHebvP3V19OGsPMhnAAA3
BoY2AAAAANhP+bUNr3dMKHBqRvcz7dOdGUQbTKUHtYQIGgAAAAAAAAAAQDGw
8i1zWi3fXQG5vurgtCDa8CBrmqn0XRBBAwAAAAAAAAAAKIlBd2n2kG//cNXj
xdwcJwXRWNEXQyYmOjmZHAAAAAAAAAAAAAAk4ew90c4sHQAAAAAAAAAAAAAk
AUE0AAAAAAAAAAAAACBiCmOd+z8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAIJH/B+Z6E9Q=
    "], {{0, 108}, {1303, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{1303, 108},
  PlotRange->{{0, 1303}, {0, 108}}]], "Text",
 CellChangeTimes->{
  3.850482880913582*^9},ExpressionUUID->"c9eb1658-41d4-41e8-817b-\
921378a56e4b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X155", "=", 
   RowBox[{"TernaCiclica", "[", 
    RowBox[{
     RowBox[{"a", "^", "2"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{"b", "^", "2"}], "-", 
       RowBox[{"c", "^", "2"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "^", "6"}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"a", "^", "4"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"b", "^", "4"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"b", "^", "2"}], " ", 
           RowBox[{"c", "^", "2"}]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"c", "^", "4"}]}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}], "^", "2"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}]}], ")"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Simplificar", "[", 
       RowBox[{"Factor", "[", 
        RowBox[{"Simplify", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"X155", ",", "#"}], "]"}], "]"}], "]"}], "]"}], "&"}], ",", 
     "halfTrianglesOfCyclicQuad"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"EstanAlineados", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.850482897785302*^9, 3.8504829005984387`*^9}, {
  3.850482950806667*^9, 3.850482960489353*^9}, {3.8504895573759604`*^9, 
  3.8504895688842907`*^9}, {3.850489603844338*^9, 3.8504896039851294`*^9}, {
  3.850556793103656*^9, 3.850556796306264*^9}, {3.850560008010232*^9, 
  3.850560031007928*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"44d72701-3455-41e8-b55f-079b25b50f9e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.8505600408752937`*^9, 3.8505641570477505`*^9, 
  3.8509132677978287`*^9, 3.8509186779806027`*^9, 3.851255555844593*^9},
 CellLabel->
  "Out[156]=",ExpressionUUID->"5d96ce23-286c-4a1e-9a95-563e48cbbcc6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 6.11", "Subsection",
 CellChangeTimes->{{3.850367662817922*^9, 3.850367681472711*^9}, {
   3.850468046384611*^9, 3.850468047773791*^9}, {3.850468091473277*^9, 
   3.8504680956818314`*^9}, {3.850474108128826*^9, 3.8504741118490105`*^9}, 
   3.850476924842958*^9, {3.8504828736251273`*^9, 3.8504828747294316`*^9}, {
   3.850483793481118*^9, 
   3.8504837935613313`*^9}},ExpressionUUID->"fa1d834b-4d33-4387-b8a0-\
59a86547a774"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3QlcVNXfB/4Lf039/yb98+uxJ8v1Zxj5cymX/OHyBFkupWDpwKOB+47b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    "], {{0, 240}, {1290, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{1290, 240},
  PlotRange->{{0, 1290}, {0, 240}}]], "Text",
 CellChangeTimes->{3.850564157109453*^9, 3.8505731410758753`*^9},
 CellLabel->
  "Out[291]=",ExpressionUUID->"e456ad8e-c1e1-4ec2-906e-e5b4d10a7afe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Specify", " ", "a", " ", "center", " ", "function", " ", "by", " ", 
    "giving", " ", "its", " ", "first", " ", "trilinear", " ", "coordinate"}],
    " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"centerFunction", "=", 
     RowBox[{"convertToABC", "[", 
      RowBox[{
       RowBox[{"Cos", "[", "A", "]"}], "+", 
       RowBox[{"k", " ", 
        RowBox[{"Cos", "[", "B", "]"}], 
        RowBox[{"Cos", "[", "C", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Multiply", " ", "the", " ", "1", "st", " ", "trilinear", " ", 
     "coordinate", " ", "by", " ", "\"\<a\>\"", " ", "to", " ", "get", " ", 
     "the", " ", "1", "st", " ", "barycentric", " ", "coordinate"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bary1", "=", 
     RowBox[{"centerFunction", "*", "a"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"center", " ", "point"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ptX", "=", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"Simplificar", "[", 
       RowBox[{"TernaCiclica", "[", "bary1", "]"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"Factor", "[", 
          RowBox[{"Simplify", "[", 
           RowBox[{"CentroETCTriangulo", "[", 
            RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "]"}], "]"}], "&"}], ",",
        "halfTrianglesOfCyclicQuad"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Verify", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"SonConciclicos", "[", 
    RowBox[{"{", 
     RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.850483818657473*^9, 3.850483830367201*^9}, {
   3.85048386331853*^9, 3.850483864132469*^9}, {3.850489642198652*^9, 
   3.850489679504198*^9}, 3.8505601339122744`*^9},
 CellLabel->
  "In[157]:=",ExpressionUUID->"faab5dfc-30de-4094-86f8-4adbd118a38e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.850489683695722*^9, 3.850560139283407*^9, 
  3.8505641601210823`*^9, 3.85091327656271*^9, 3.850918687132662*^9, 
  3.851255558283012*^9},
 CellLabel->
  "Out[161]=",ExpressionUUID->"dab92c7b-ff17-4005-8530-37dbd6809d12"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Theorem 6.12", "Subsection",
 CellChangeTimes->{{3.850367662817922*^9, 3.850367681472711*^9}, {
   3.850468046384611*^9, 3.850468047773791*^9}, {3.850468091473277*^9, 
   3.8504680956818314`*^9}, {3.850474108128826*^9, 3.8504741118490105`*^9}, 
   3.850476924842958*^9, {3.8504828736251273`*^9, 3.8504828747294316`*^9}, {
   3.850483793481118*^9, 3.8504837935613313`*^9}, 
   3.850484214018911*^9},ExpressionUUID->"ccb2ea3d-3fe9-49ce-ac20-\
a5e1e6710dca"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQl4FMW68N/JHwQeR/lHL36CyHI4wcgFUVbD8pmIh0UhE5SEAyaI7BC2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    "], {{0, 228}, {1308, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{1308, 228},
  PlotRange->{{0, 1308}, {0, 228}}]], "Text",
 CellChangeTimes->{
  3.850484222072954*^9},ExpressionUUID->"9d980d69-abb1-4688-9559-\
aaf13bce66e2"],

Cell[CellGroupData[{

Cell["Centroid X(1)", "Subsubsection",
 CellChangeTimes->{{3.850484232221359*^9, 
  3.8504842429463243`*^9}},ExpressionUUID->"f065c998-9dcc-43f1-83e2-\
7d5019a0ea96"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Baricentro", ",", "halfTrianglesOfCyclicQuad"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SonConciclicos", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8504842945782022`*^9, 3.8504843173350115`*^9}, {
  3.8504843628488064`*^9, 3.8504843970121717`*^9}, {3.8505602198274813`*^9, 
  3.8505602287334037`*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"65e963c0-8f00-47bd-9e6c-19108ba8c156"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.850484399218155*^9, 3.850560231780064*^9, 
  3.850564160311201*^9, 3.850913291259375*^9, 3.8509186961148667`*^9, 
  3.8512555584835787`*^9},
 CellLabel->
  "Out[163]=",ExpressionUUID->"de3d3d48-39ed-4f4b-bae2-963ec1a9aedc"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthocenter X(4)", "Subsubsection",
 CellChangeTimes->{{3.850484232221359*^9, 3.8504842429463243`*^9}, {
  3.8504843544730864`*^9, 3.8504843555765533`*^9}, {3.8504844574861975`*^9, 
  3.8504844601363015`*^9}},ExpressionUUID->"5b61f3d6-f0ff-4d04-8764-\
e63c71511e17"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Ortocentro", ",", "halfTrianglesOfCyclicQuad"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SonConciclicos", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8504842945782022`*^9, 3.8504843173350115`*^9}, {
   3.8504844202220125`*^9, 3.8504844308861127`*^9}, 3.8505603151356015`*^9},
 CellLabel->
  "In[164]:=",ExpressionUUID->"04d11a2d-4d74-4abe-aec8-2500bfaeea74"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.850484433707146*^9, 3.850560278247307*^9, 
  3.850560316693863*^9, 3.8505641607770343`*^9, 3.8509132971223073`*^9, 
  3.8509186989200125`*^9, 3.85125555894869*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"b72edade-1252-4e0a-9c5e-cfdbc85a2067"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Nine-point center X(5)", "Subsubsection",
 CellChangeTimes->{{3.850484232221359*^9, 3.8504842429463243`*^9}, {
   3.8504843544730864`*^9, 3.8504843555765533`*^9}, {3.8504844651194243`*^9, 
   3.8504844731201997`*^9}, 
   3.851256135414507*^9},ExpressionUUID->"849dca36-d4c7-4786-985e-\
f3f79fa64a43"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"CentroNuevePuntos", ",", "halfTrianglesOfCyclicQuad"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SonConciclicos", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8504842945782022`*^9, 3.8504843173350115`*^9}, {
   3.8504844202220125`*^9, 3.8504844308861127`*^9}, {3.8504844791234584`*^9, 
   3.8504844857766123`*^9}, 3.85056035714793*^9},
 CellLabel->
  "In[166]:=",ExpressionUUID->"cba569d5-874c-4dc8-a35a-d6eaeb3f1732"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.850484433707146*^9, 3.850484617727498*^9, 
  3.850560359866391*^9, 3.8505641617076225`*^9, 3.8509133029382915`*^9, 
  3.8509187015099583`*^9, 3.851255559846383*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"9eff5376-6251-43c8-b156-5367a6f41b3c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1st Fermat point X(13)", "Subsubsection",
 CellChangeTimes->{{3.850484232221359*^9, 3.8504842429463243`*^9}, {
   3.8504843544730864`*^9, 3.8504843555765533`*^9}, {3.8504844574861975`*^9, 
   3.8504844601363015`*^9}, 3.8504868315667653`*^9, {3.8504869868224125`*^9, 
   3.850486989670785*^9}, {3.8504885806651306`*^9, 3.850488582296401*^9}, {
   3.8505508180415297`*^9, 3.8505508348875923`*^9}, {3.850560919681529*^9, 
   3.8505609217849116`*^9}, {3.8509133721238956`*^9, 
   3.850913378501161*^9}},ExpressionUUID->"a0c83580-9a15-457e-8fd7-\
52105ae684f4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Fermat1", ",", "halfTrianglesOfGeneralQuad"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"circFGH", "=", 
   RowBox[{"CircunferenciaTresPuntos", "[", 
    RowBox[{"{", 
     RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{"circFGH", ",", "ptI"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{"expr", "/.", "sustS"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{"expr", "/.", "sustD"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"expr", "===", "0"}]}], "Input",
 CellChangeTimes->{{3.850560689846411*^9, 3.850560830310678*^9}, 
   3.850560877001671*^9},
 CellLabel->
  "In[168]:=",ExpressionUUID->"351983c8-e031-4ca2-8ef9-981673b64e04"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.8509134062918315`*^9, 3.8509188967919445`*^9, 
  3.851255648660911*^9},
 CellLabel->
  "Out[173]=",ExpressionUUID->"207696e4-a15c-44a4-84cf-ec1c08c427aa"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2nd Fermat point X(14)", "Subsubsection",
 CellChangeTimes->{{3.850484232221359*^9, 3.8504842429463243`*^9}, {
   3.8504843544730864`*^9, 3.8504843555765533`*^9}, {3.8504844574861975`*^9, 
   3.8504844601363015`*^9}, 3.8504868315667653`*^9, {3.8504869868224125`*^9, 
   3.850486989670785*^9}, {3.8504885806651306`*^9, 3.850488582296401*^9}, {
   3.8504886853217535`*^9, 3.8504886888881617`*^9}, {3.8505508269225197`*^9, 
   3.8505508309129157`*^9}, {3.850561090217143*^9, 3.850561092073148*^9}, {
   3.850913384020381*^9, 
   3.8509133883956785`*^9}},ExpressionUUID->"91c2a0ae-a331-45b6-8ea0-\
33af64e87e77"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Fermat2", ",", "halfTrianglesOfGeneralQuad"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"circFGH", "=", 
   RowBox[{"CircunferenciaTresPuntos", "[", 
    RowBox[{"{", 
     RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{"circFGH", ",", "ptI"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{"expr", "/.", "sustS"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{"expr", "/.", "sustD"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"expr", "===", "0"}]}], "Input",
 CellChangeTimes->{{3.8505506371460733`*^9, 3.850550640072274*^9}, {
  3.8505610734333324`*^9, 3.850561079123322*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"5454ddcd-be2f-44d8-b75a-fdb2ada2fc5b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.850550799959421*^9, 3.850561172947199*^9, 
  3.8509134985537033`*^9, 3.8509189894094615`*^9, 3.8512557433366327`*^9},
 CellLabel->
  "Out[179]=",ExpressionUUID->"43533379-5a86-4ed0-a11f-ea53208c9966"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["de Longchamps point X(20)", "Subsubsection",
 CellChangeTimes->{{3.850484232221359*^9, 3.8504842429463243`*^9}, {
  3.8504843544730864`*^9, 3.8504843555765533`*^9}, {3.8504844651194243`*^9, 
  3.8504844731201997`*^9}, {3.8504848044193554`*^9, 3.8504848232254534`*^9}, {
  3.851255748284112*^9, 
  3.851255755219713*^9}},ExpressionUUID->"c3e5e43f-c18a-4bbc-a4f9-\
b8929e69d608"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"DeLongchamps", ",", "halfTrianglesOfCyclicQuad"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SonConciclicos", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8504842945782022`*^9, 3.8504843173350115`*^9}, {
   3.8504844202220125`*^9, 3.8504844308861127`*^9}, {3.8504844791234584`*^9, 
   3.8504844857766123`*^9}, {3.850484828458621*^9, 3.850484832598402*^9}, 
   3.8505604189213676`*^9},
 CellLabel->
  "In[180]:=",ExpressionUUID->"3b717c93-038a-44b5-ac8d-5b8c1214eafb"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.850484433707146*^9, 3.850484617727498*^9, 3.8504848367438354`*^9, 
   3.850560504358387*^9, 3.85091350892058*^9, {3.850918704515992*^9, 
   3.8509187117684617`*^9}, 3.8509187631052217`*^9, 3.851255744347456*^9},
 CellLabel->
  "Out[181]=",ExpressionUUID->"022415fc-a04b-4794-a736-df18207d3997"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Far out point X(23)", "Subsubsection",
 CellChangeTimes->{{3.850484232221359*^9, 3.8504842429463243`*^9}, {
  3.8504843544730864`*^9, 3.8504843555765533`*^9}, {3.8504844651194243`*^9, 
  3.8504844731201997`*^9}, {3.8504848044193554`*^9, 3.8504848232254534`*^9}, {
  3.850484886280896*^9, 3.850484896359129*^9}, {3.850485054943184*^9, 
  3.850485063931237*^9}},ExpressionUUID->"95c528b5-bc5f-40f9-be0c-\
3daaeaf0b4de"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X23", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Simplificar", "[", 
       RowBox[{"Factor", "[", 
        RowBox[{"Simplify", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"X23", ",", "#"}], "]"}], "]"}], "]"}], "]"}], "&"}], ",", 
     "halfTrianglesOfCyclicQuad"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SonConciclicos", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8504842945782022`*^9, 3.8504843173350115`*^9}, {
  3.8504844202220125`*^9, 3.8504844308861127`*^9}, {3.8504844791234584`*^9, 
  3.8504844857766123`*^9}, {3.850484828458621*^9, 3.850484832598402*^9}, {
  3.8504849409955997`*^9, 3.850484980953805*^9}, {3.850485072592391*^9, 
  3.8504850828347335`*^9}, {3.850489729784341*^9, 3.850489756224188*^9}, {
  3.850560430748908*^9, 3.850560436485777*^9}},
 CellLabel->
  "In[182]:=",ExpressionUUID->"74f13bd7-e580-4a0d-bf61-b10825baa01d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.850484986106408*^9, 3.8504850859776983`*^9, 
  3.850489764886042*^9, 3.8505605396852813`*^9, 3.8509135185047894`*^9, 
  3.8509187722634916`*^9, 3.851255747838643*^9},
 CellLabel->
  "Out[184]=",ExpressionUUID->"d93df1a6-27bb-4a6a-9b7f-a84c571d1d3a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tarry point X(98)", "Subsubsection",
 CellChangeTimes->{{3.850484232221359*^9, 3.8504842429463243`*^9}, {
  3.8504843544730864`*^9, 3.8504843555765533`*^9}, {3.8504844651194243`*^9, 
  3.8504844731201997`*^9}, {3.8504848044193554`*^9, 3.8504848232254534`*^9}, {
  3.850484886280896*^9, 3.850484896359129*^9}, {3.8504851199469604`*^9, 
  3.850485125089512*^9}},ExpressionUUID->"8b327616-208a-4034-bbee-\
7dfbdb5cbace"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X98", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Simplificar", "[", 
       RowBox[{"Factor", "[", 
        RowBox[{"Simplify", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"X98", ",", "#"}], "]"}], "]"}], "]"}], "]"}], "&"}], ",", 
     "halfTrianglesOfCyclicQuad"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SonConciclicos", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8504842945782022`*^9, 3.8504843173350115`*^9}, {
  3.8504844202220125`*^9, 3.8504844308861127`*^9}, {3.8504844791234584`*^9, 
  3.8504844857766123`*^9}, {3.850484828458621*^9, 3.850484832598402*^9}, {
  3.8504849409955997`*^9, 3.850484980953805*^9}, {3.850485138021637*^9, 
  3.850485145758862*^9}, {3.850489783072225*^9, 3.850489809984475*^9}, {
  3.850560444972869*^9, 3.8505604505523796`*^9}},
 CellLabel->
  "In[185]:=",ExpressionUUID->"ebe8826b-ce18-4b99-ace1-d218af4649d6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.8504898418313804`*^9, 3.850560588762813*^9, 
  3.850913536708531*^9, 3.850918789115551*^9, 3.851255759767332*^9},
 CellLabel->
  "Out[187]=",ExpressionUUID->"fc65b115-952f-4d16-9150-100d3820ce85"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Steiner point X(99)", "Subsubsection",
 CellChangeTimes->{{3.850484232221359*^9, 3.8504842429463243`*^9}, {
  3.8504843544730864`*^9, 3.8504843555765533`*^9}, {3.8504844651194243`*^9, 
  3.8504844731201997`*^9}, {3.8504848044193554`*^9, 3.8504848232254534`*^9}, {
  3.850484886280896*^9, 
  3.850484896359129*^9}},ExpressionUUID->"0149a7cc-d157-408b-9784-\
99d1d035aa9e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"X99", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Simplificar", "[", 
       RowBox[{"Factor", "[", 
        RowBox[{"Simplify", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"X99", ",", "#"}], "]"}], "]"}], "]"}], "]"}], "&"}], ",", 
     "halfTrianglesOfCyclicQuad"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SonConciclicos", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8504842945782022`*^9, 3.8504843173350115`*^9}, {
  3.8504844202220125`*^9, 3.8504844308861127`*^9}, {3.8504844791234584`*^9, 
  3.8504844857766123`*^9}, {3.850484828458621*^9, 3.850484832598402*^9}, {
  3.8504849409955997`*^9, 3.850484980953805*^9}, {3.850489850576621*^9, 
  3.8504898823661833`*^9}, {3.8505604557781134`*^9, 3.8505604624956913`*^9}},
 CellLabel->
  "In[188]:=",ExpressionUUID->"01d90f84-e42c-4198-9386-26006d5faef6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.850484986106408*^9, 3.8504898856695385`*^9, 
  3.8505606334529405`*^9, 3.8509135523004475`*^9, 3.850918803491705*^9, 
  3.85125576802633*^9},
 CellLabel->
  "Out[190]=",ExpressionUUID->"ce7c0b1f-a778-4bdb-ae32-080e1f82e217"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{933, 1124},
WindowMargins->{{133, Automatic}, {Automatic, 71}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 297, 5, 98, "Title",ExpressionUUID->"1c7fd21f-91de-44e5-8756-935f2997f1d7"],
Cell[880, 29, 1270, 23, 219, "Text",ExpressionUUID->"b2c8116c-ec79-4fb1-b532-250e1785d0c8",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[2175, 56, 263, 4, 67, "Section",ExpressionUUID->"842befdc-3cf0-415f-8b25-c10324ffc1f1"],
Cell[CellGroupData[{
Cell[2463, 64, 399, 10, 53, "Subsection",ExpressionUUID->"bbaef35b-fd46-44f6-8e80-c44bf68717ee"],
Cell[2865, 76, 715, 18, 34, "Text",ExpressionUUID->"0059b8dc-ad99-42fc-a3b6-d879ef9097ac"],
Cell[3583, 96, 36425, 919, 2526, "Input",ExpressionUUID->"57ddaf88-15ec-4784-8204-24a0ef11a487"]
}, Closed]],
Cell[CellGroupData[{
Cell[40045, 1020, 295, 5, 37, "Subsection",ExpressionUUID->"06785e74-858a-4fba-88ad-d2a22a9f4998"],
Cell[40343, 1027, 16882, 460, 1492, "Input",ExpressionUUID->"f5e25769-1ea5-4c75-9916-55398bf3e085"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[57274, 1493, 231, 4, 53, "Section",ExpressionUUID->"3e0086bf-9422-4176-8e91-c63f1a449dad"],
Cell[57508, 1499, 1972, 51, 143, "Input",ExpressionUUID->"ed2efd3a-5513-4d7f-91d5-aa4c40ba43b6"],
Cell[59483, 1552, 323, 6, 34, "Text",ExpressionUUID->"7218253a-f9e3-4e79-bc14-b67cfbaa90a7"],
Cell[CellGroupData[{
Cell[59831, 1562, 393, 8, 28, "Input",ExpressionUUID->"fb0b2316-1cc0-4ff9-9612-a28276348a1b"],
Cell[60227, 1572, 688, 12, 70, "Output",ExpressionUUID->"7d622c77-ee5c-4361-9e77-77b9be7bfdc6"]
}, Open  ]],
Cell[60930, 1587, 213, 4, 34, "Text",ExpressionUUID->"eafe411f-dfde-47ec-bad4-3820d3bd5ab5"],
Cell[CellGroupData[{
Cell[61168, 1595, 394, 10, 28, "Input",ExpressionUUID->"f9553f73-9b84-4571-ac63-7c64c684c724"],
Cell[61565, 1607, 599, 11, 70, "Output",ExpressionUUID->"61f5051f-4b8b-4dba-9ced-fbb4f44e81ba"]
}, Open  ]],
Cell[62179, 1621, 241, 4, 34, "Text",ExpressionUUID->"aa8d4996-63ea-4ed9-a0d4-085fc14e0816"],
Cell[CellGroupData[{
Cell[62445, 1629, 1252, 33, 48, "Input",ExpressionUUID->"5af2e9d2-8eaa-44f7-9dd4-ec3f8068c3e3"],
Cell[63700, 1664, 1034, 25, 70, "Output",ExpressionUUID->"cbd8980d-b8c2-4ed6-ad56-ea3b67efa2e1"]
}, Open  ]],
Cell[64749, 1692, 570, 9, 34, "Text",ExpressionUUID->"78961a6c-61a2-424e-9f9b-9c12e1cd90c9"],
Cell[65322, 1703, 872, 26, 32, "Input",ExpressionUUID->"9812470e-839c-411e-bbe5-1d4a082d2039"]
}, Closed]],
Cell[CellGroupData[{
Cell[66231, 1734, 213, 4, 53, "Section",ExpressionUUID->"1652b3e5-8836-4d3a-ba58-f1053f99bfcd"],
Cell[66447, 1740, 364, 6, 35, "Text",ExpressionUUID->"df684cc8-f09e-40ad-af97-6ee54bcf5e39"],
Cell[66814, 1748, 789, 19, 30, "Input",ExpressionUUID->"a87552a0-095f-49ea-ae9a-b85706010ccb"],
Cell[67606, 1769, 364, 6, 35, "Text",ExpressionUUID->"eef60890-d21c-40a9-a231-4f2e16a6ff64"],
Cell[67973, 1777, 710, 18, 30, "Input",ExpressionUUID->"7c7c5886-d881-4b48-8c2d-96409472e4a1"],
Cell[CellGroupData[{
Cell[68708, 1799, 409, 6, 54, "Subsection",ExpressionUUID->"aa1e1384-cc65-4bf2-89db-e20816cdccd4"],
Cell[69120, 1807, 105781, 1740, 431, "Text",ExpressionUUID->"db3a72e1-fa24-4759-ae2e-bf7bc9780a4c"],
Cell[CellGroupData[{
Cell[174926, 3551, 2166, 63, 117, "Input",ExpressionUUID->"5cea681d-8bb1-49dd-a61e-f40950bcb0ac"],
Cell[177095, 3616, 308, 5, 34, "Output",ExpressionUUID->"c9c38e6b-823e-422e-801c-108d31d7b397"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[177452, 3627, 411, 6, 38, "Subsection",ExpressionUUID->"6cff85a6-6ec8-4ed4-a9d8-7a640c6dd7a7"],
Cell[177866, 3635, 33774, 559, 82, "Text",ExpressionUUID->"b71dfe76-4e1f-4207-83cc-fde6f563eec3"],
Cell[CellGroupData[{
Cell[211665, 4198, 381, 6, 45, "Subsubsection",ExpressionUUID->"f35cafcc-c84d-41ff-89ce-0dac02cf6b19"],
Cell[CellGroupData[{
Cell[212071, 4208, 743, 17, 52, "Input",ExpressionUUID->"042186c9-72fd-491b-8f3c-1f3b5b49fef6"],
Cell[212817, 4227, 331, 6, 34, "Output",ExpressionUUID->"6b8d8e98-4425-444a-a17a-02ceb0aa48d3"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[213197, 4239, 459, 7, 37, "Subsubsection",ExpressionUUID->"f371521d-eb6a-48e9-a2f7-52534997fde1"],
Cell[CellGroupData[{
Cell[213681, 4250, 794, 18, 52, "Input",ExpressionUUID->"935b73b0-0939-4a4e-bce2-15985588d8bd"],
Cell[214478, 4270, 302, 5, 34, "Output",ExpressionUUID->"5e0beb26-3e21-402e-bd95-16dd5bb61809"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[214853, 4283, 159, 3, 67, "Section",ExpressionUUID->"633221b1-6e5a-4260-9424-adc26de09800"],
Cell[215015, 4288, 310, 5, 35, "Text",ExpressionUUID->"94b81001-fb04-4746-b0c7-2314a1ff7944"],
Cell[215328, 4295, 691, 18, 30, "Input",ExpressionUUID->"49922df0-7374-4c1c-8e4e-9f103a17f2bf"],
Cell[216022, 4315, 309, 5, 35, "Text",ExpressionUUID->"2e096209-7f68-4b19-9bb5-de0d1e0fb8a3"],
Cell[216334, 4322, 631, 17, 30, "Input",ExpressionUUID->"849a5de4-b880-4e5b-8ea8-88ed06a0fc69"],
Cell[CellGroupData[{
Cell[216990, 4343, 307, 5, 54, "Subsection",ExpressionUUID->"7bcbfcce-108d-47e5-9bb1-5b4b0d34cc12"],
Cell[217300, 4350, 22904, 381, 70, "Text",ExpressionUUID->"abde8aa8-3224-46f9-b3a7-cb77b4a5bbc6"],
Cell[CellGroupData[{
Cell[240229, 4735, 787, 19, 52, "Input",ExpressionUUID->"5e542af9-d35f-4dc5-b94c-89f6258492ff"],
Cell[241019, 4756, 333, 6, 34, "Output",ExpressionUUID->"d49c947a-4880-4d79-a4fd-dbec3287807b"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[241401, 4768, 332, 5, 38, "Subsection",ExpressionUUID->"44dd518d-9e65-41d5-a445-6759050a115b"],
Cell[241736, 4775, 39066, 646, 135, "Text",ExpressionUUID->"9d9218fc-ed17-40b5-b990-3148f9e24f84"],
Cell[CellGroupData[{
Cell[280827, 5425, 2711, 62, 220, "Input",ExpressionUUID->"9df1baba-90ee-4cbb-8cc9-3e06d70befd6"],
Cell[283541, 5489, 209, 4, 34, "Output",ExpressionUUID->"2671de3d-1d2c-4308-ae64-d1e2eea74939"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[283799, 5499, 387, 6, 38, "Subsection",ExpressionUUID->"81ed3610-9950-4643-b4fa-fc52902f3e6a"],
Cell[284189, 5507, 28936, 480, 75, "Text",ExpressionUUID->"c9eb1658-41d4-41e8-817b-921378a56e4b"],
Cell[CellGroupData[{
Cell[313150, 5991, 2276, 65, 157, "Input",ExpressionUUID->"44d72701-3455-41e8-b55f-079b25b50f9e"],
Cell[315429, 6058, 255, 4, 34, "Output",ExpressionUUID->"5d96ce23-286c-4a1e-9a95-563e48cbbcc6"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[315733, 6068, 439, 7, 38, "Subsection",ExpressionUUID->"fa1d834b-4d33-4387-b8a0-59a86547a774"],
Cell[316175, 6077, 35803, 591, 150, "Text",ExpressionUUID->"e456ad8e-c1e1-4ec2-906e-e5b4d10a7afe"],
Cell[CellGroupData[{
Cell[352003, 6672, 2232, 56, 220, "Input",ExpressionUUID->"faab5dfc-30de-4094-86f8-4adbd118a38e"],
Cell[354238, 6730, 273, 5, 34, "Output",ExpressionUUID->"dab92c7b-ff17-4005-8530-37dbd6809d12"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[354560, 6741, 461, 7, 38, "Subsection",ExpressionUUID->"ccb2ea3d-3fe9-49ce-ac20-a5e1e6710dca"],
Cell[355024, 6750, 53239, 879, 141, "Text",ExpressionUUID->"9d980d69-abb1-4688-9559-aaf13bce66e2"],
Cell[CellGroupData[{
Cell[408288, 7633, 166, 3, 45, "Subsubsection",ExpressionUUID->"f065c998-9dcc-43f1-83e2-7d5019a0ea96"],
Cell[CellGroupData[{
Cell[408479, 7640, 643, 16, 48, "Input",ExpressionUUID->"65e963c0-8f00-47bd-9e6c-19108ba8c156"],
Cell[409125, 7658, 276, 5, 70, "Output",ExpressionUUID->"de3d3d48-39ed-4f4b-bae2-963ec1a9aedc"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[409450, 7669, 272, 4, 37, "Subsubsection",ExpressionUUID->"5b61f3d6-f0ff-4d04-8764-e63c71511e17"],
Cell[CellGroupData[{
Cell[409747, 7677, 615, 15, 48, "Input",ExpressionUUID->"04d11a2d-4d74-4abe-aec8-2500bfaeea74"],
Cell[410365, 7694, 299, 5, 70, "Output",ExpressionUUID->"b72edade-1252-4e0a-9c5e-cfdbc85a2067"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[410713, 7705, 306, 5, 37, "Subsubsection",ExpressionUUID->"849dca36-d4c7-4786-985e-f3f79fa64a43"],
Cell[CellGroupData[{
Cell[411044, 7714, 673, 16, 52, "Input",ExpressionUUID->"cba569d5-874c-4dc8-a35a-d6eaeb3f1732"],
Cell[411720, 7732, 300, 5, 34, "Output",ExpressionUUID->"9eff5376-6251-43c8-b156-5367a6f41b3c"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[412069, 7743, 562, 8, 37, "Subsubsection",ExpressionUUID->"a0c83580-9a15-457e-8fd7-52105ae684f4"],
Cell[CellGroupData[{
Cell[412656, 7755, 1082, 30, 136, "Input",ExpressionUUID->"351983c8-e031-4ca2-8ef9-981673b64e04"],
Cell[413741, 7787, 207, 4, 34, "Output",ExpressionUUID->"207696e4-a15c-44a4-84cf-ec1c08c427aa"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[413997, 7797, 614, 9, 37, "Subsubsection",ExpressionUUID->"91c2a0ae-a331-45b6-8ea0-33af64e87e77"],
Cell[CellGroupData[{
Cell[414636, 7810, 1109, 30, 136, "Input",ExpressionUUID->"5454ddcd-be2f-44d8-b75a-fdb2ada2fc5b"],
Cell[415748, 7842, 253, 4, 34, "Output",ExpressionUUID->"43533379-5a86-4ed0-a11f-ea53208c9966"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[416050, 7852, 383, 6, 37, "Subsubsection",ExpressionUUID->"c3e5e43f-c18a-4bbc-a4f9-b8929e69d608"],
Cell[CellGroupData[{
Cell[416458, 7862, 721, 17, 52, "Input",ExpressionUUID->"3b717c93-038a-44b5-ac8d-5b8c1214eafb"],
Cell[417182, 7881, 350, 6, 34, "Output",ExpressionUUID->"022415fc-a04b-4794-a736-df18207d3997"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[417581, 7893, 423, 6, 37, "Subsubsection",ExpressionUUID->"95c528b5-bc5f-40f9-be0c-3daaeaf0b4de"],
Cell[CellGroupData[{
Cell[418029, 7903, 2219, 62, 96, "Input",ExpressionUUID->"74f13bd7-e580-4a0d-bf61-b10825baa01d"],
Cell[420251, 7967, 302, 5, 34, "Output",ExpressionUUID->"d93df1a6-27bb-4a6a-9b7f-a84c571d1d3a"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[420602, 7978, 423, 6, 37, "Subsubsection",ExpressionUUID->"8b327616-208a-4034-bbee-7dfbdb5cbace"],
Cell[CellGroupData[{
Cell[421050, 7988, 3271, 95, 119, "Input",ExpressionUUID->"ebe8826b-ce18-4b99-ace1-d218af4649d6"],
Cell[424324, 8085, 249, 4, 34, "Output",ExpressionUUID->"fc65b115-952f-4d16-9150-100d3820ce85"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[424622, 8095, 377, 6, 37, "Subsubsection",ExpressionUUID->"0149a7cc-d157-408b-9784-99d1d035aa9e"],
Cell[CellGroupData[{
Cell[425024, 8105, 2037, 59, 96, "Input",ExpressionUUID->"01d90f84-e42c-4198-9386-26006d5faef6"],
Cell[427064, 8166, 277, 5, 34, "Output",ExpressionUUID->"ce7c0b1f-a778-4bdb-ae32-080e1f82e217"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)

